/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import java.util.Optional;
import java.util.Set;

public class OptionalMapIdentity
extends AJavaparserExprMutator {
    public String minimalJavaVersion() {
        return "1.8";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Optional", (Object)"Redundancy");
    }

    protected Class<?> getRequiredType() {
        return Optional.class;
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        if (!expr.getNode().isMethodCallExpr()) {
            return false;
        }
        MethodCallExpr mapCall = expr.getNode().asMethodCallExpr();
        if (!"map".equals(mapCall.getNameAsString())) {
            return false;
        }
        if (mapCall.getArguments().size() != 1) {
            return false;
        }
        if (!MethodCallExprHelpers.scopeHasRequiredType(expr.editNode(mapCall.getScope()), this.getRequiredType())) {
            return false;
        }
        if (!mapCall.getArgument(0).isLambdaExpr()) {
            return false;
        }
        LambdaExpr lambdaExpr = mapCall.getArgument(0).asLambdaExpr();
        if (lambdaExpr.getParameters().size() != 1) {
            return false;
        }
        Parameter firstParameter = lambdaExpr.getParameter(0);
        if (lambdaExpr.getExpressionBody().isEmpty()) {
            return false;
        }
        if (!((Expression)lambdaExpr.getExpressionBody().get()).equals((Object)firstParameter.getNameAsExpression())) {
            return false;
        }
        return this.tryReplace(expr, (Node)mapCall.getScope().get());
    }
}

