/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import java.util.Optional;
import java.util.Set;

public class GuavaStringsIsNullOrEmpty
extends AJavaparserExprMutator {
    public String minimalJavaVersion() {
        return "11";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Guava", (Object)"String");
    }

    public String minimalGuavaVersion() {
        return "3.0";
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        Expression right;
        if (!expr.getNode().isBinaryExpr()) {
            return false;
        }
        BinaryExpr binaryExpr = expr.getNode().asBinaryExpr();
        if (binaryExpr.getOperator() != BinaryExpr.Operator.OR) {
            return false;
        }
        Expression left = binaryExpr.getLeft();
        Optional<Expression> stringIsNullOrEmpty = this.oneIsNullOtherIsEmpty(expr, left, right = binaryExpr.getRight());
        if (stringIsNullOrEmpty.isEmpty()) {
            return false;
        }
        Optional optCompilationUnit = expr.getNode().findCompilationUnit();
        if (optCompilationUnit.isEmpty()) {
            return false;
        }
        ((CompilationUnit)optCompilationUnit.get()).addImport(Strings.class.getName());
        MethodCallExpr replacement = new MethodCallExpr((Expression)new NameExpr("Strings"), "isNullOrEmpty", new NodeList((Node[])new Expression[]{stringIsNullOrEmpty.get()}));
        return this.tryReplace((Node)binaryExpr, (Node)replacement);
    }

    private Optional<Expression> oneIsNullOtherIsEmpty(NodeAndSymbolSolver<?> context, Expression left, Expression right) {
        Optional<Expression> leftIsNullCheck = this.searchNullCheck(left);
        if (leftIsNullCheck.isPresent()) {
            if (this.isEmpty(context, right, leftIsNullCheck.get())) {
                return right.asMethodCallExpr().getScope();
            }
            return Optional.empty();
        }
        Optional<Expression> rightIsNullCheck = this.searchNullCheck(right);
        if (rightIsNullCheck.isPresent() && this.isEmpty(context, left, rightIsNullCheck.get())) {
            return left.asMethodCallExpr().getScope();
        }
        return Optional.empty();
    }

    private boolean isEmpty(NodeAndSymbolSolver<?> context, Expression shouldCallIsEmpty, Expression isNullChecked) {
        if (!shouldCallIsEmpty.isMethodCallExpr()) {
            return false;
        }
        MethodCallExpr asMethodCallExpr = shouldCallIsEmpty.asMethodCallExpr();
        if (asMethodCallExpr.getScope().isEmpty()) {
            return false;
        }
        if (!"isEmpty".equals(asMethodCallExpr.getNameAsString()) || !MethodCallExprHelpers.scopeHasRequiredType(context.editNode(asMethodCallExpr.getScope()), String.class)) {
            return false;
        }
        return ((Expression)asMethodCallExpr.getScope().get()).equals((Object)isNullChecked);
    }

    private Optional<Expression> searchNullCheck(Expression expr) {
        if (!expr.isBinaryExpr()) {
            return Optional.empty();
        }
        BinaryExpr binaryExpr = expr.asBinaryExpr();
        if (binaryExpr.getLeft().isNullLiteralExpr()) {
            return Optional.of(binaryExpr.getRight());
        }
        if (binaryExpr.getRight().isNullLiteralExpr()) {
            return Optional.of(binaryExpr.getLeft());
        }
        return Optional.empty();
    }
}

