/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ForEachStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.resolution.types.ResolvedType;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserStmtMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.LambdaExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.meta.ApplyAfterMe;
import eu.solven.cleanthat.engine.java.refactorer.mutators.LambdaReturnsSingleStatement;
import java.util.Optional;
import java.util.Set;

@ApplyAfterMe(value={LambdaReturnsSingleStatement.class})
public class ForEachToIterableForEach
extends AJavaparserStmtMutator {
    public String minimalJavaVersion() {
        return "1.8";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Iterable", (Object)"Loop", (Object)"Stream");
    }

    public Optional<String> getJSparrowId() {
        return Optional.of("EnhancedForLoopToStreamForEach");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/enhanced-for-loop-to-stream-for-each.html";
    }

    public Set<String> getLegacyIds() {
        return Set.of("EnhancedForLoopToForEach");
    }

    @Override
    protected boolean processStatement(NodeAndSymbolSolver<Statement> stmt) {
        if (!stmt.getNode().isForEachStmt()) {
            return false;
        }
        ForEachStmt forEachStmt = stmt.getNode().asForEachStmt();
        Optional<ResolvedType> resolved = MethodCallExprHelpers.optResolvedType(stmt.editNode(forEachStmt.getIterable()));
        if (resolved.isEmpty()) {
            return false;
        }
        if (resolved.get().isArray()) {
            return false;
        }
        Optional<LambdaExpr> optLambdaExpr = LambdaExprHelpers.makeLambdaExpr(forEachStmt.getVariableDeclarator().getName(), forEachStmt.getBody());
        if (optLambdaExpr.isEmpty()) {
            return false;
        }
        MethodCallExpr forEach = new MethodCallExpr(forEachStmt.getIterable(), "forEach", new NodeList((Node[])new Expression[]{(Expression)optLambdaExpr.get()}));
        return this.tryReplace((Node)forEachStmt, (Node)new ExpressionStmt((Expression)forEach));
    }
}

