/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ForEachStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.UnknownType;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserStmtMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.LambdaExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.helpers.NameExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.meta.ApplyAfterMe;
import eu.solven.cleanthat.engine.java.refactorer.mutators.LambdaIsMethodReference;
import eu.solven.cleanthat.engine.java.refactorer.mutators.RedundantLogicalComplementsInStream;
import eu.solven.cleanthat.engine.java.refactorer.mutators.StreamMutatorHelpers;
import java.util.Optional;
import java.util.Set;

@ApplyAfterMe(value={RedundantLogicalComplementsInStream.class, LambdaIsMethodReference.class})
public class ForEachIfToIfStreamAnyMatch
extends AJavaparserStmtMutator {
    static final String ANY_MATCH = "anyMatch";

    public String minimalJavaVersion() {
        return "1.8";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Stream", (Object)"Loop");
    }

    public Optional<String> getJSparrowId() {
        return Optional.of("EnhancedForLoopToStreamAnyMatch");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/enhanced-for-loop-to-stream-any-match.html";
    }

    @Override
    protected boolean processStatement(NodeAndSymbolSolver<Statement> stmt) {
        if (!stmt.getNode().isForEachStmt()) {
            return false;
        }
        ForEachStmt forEachStmt = stmt.getNode().asForEachStmt();
        Optional<IfStmt> optIfStmt = StreamMutatorHelpers.findSingleIfThenStmt(forEachStmt);
        if (optIfStmt.isEmpty()) {
            return false;
        }
        IfStmt ifStmt = optIfStmt.get();
        Statement thenStmt = ifStmt.getThenStmt();
        if (!thenStmt.isBlockStmt()) {
            return false;
        }
        BlockStmt thenAsBlockStmt = thenStmt.asBlockStmt();
        if (thenAsBlockStmt.getStatements().isEmpty()) {
            return false;
        }
        NameExpr variableName = forEachStmt.getVariableDeclarator().getNameAsExpression();
        if (NameExprHelpers.isNameReferenced(variableName, (Node)thenAsBlockStmt)) {
            return false;
        }
        Statement lastStmt = thenAsBlockStmt.getStatement(thenAsBlockStmt.getStatements().size() - 1);
        if (!lastStmt.isReturnStmt() && !lastStmt.isBreakStmt()) {
            return false;
        }
        boolean replaced = this.replaceForEachIfByIfStream(forEachStmt, ifStmt, thenAsBlockStmt);
        if (replaced && lastStmt.isBreakStmt()) {
            this.tryRemove((Node)lastStmt);
        }
        return replaced;
    }

    protected boolean replaceForEachIfByIfStream(ForEachStmt forEachStmt, IfStmt ifStmt, BlockStmt thenAsBlockStmt) {
        VariableDeclarator variable = (VariableDeclarator)forEachStmt.getVariable().getVariables().get(0);
        Optional<LambdaExpr> lambdaExpr = ForEachIfToIfStreamAnyMatch.ifConditionToLambda(ifStmt, variable);
        if (lambdaExpr.isEmpty()) {
            return false;
        }
        MethodCallExpr withStream = new MethodCallExpr(forEachStmt.getIterable(), "stream");
        MethodCallExpr withStream2 = new MethodCallExpr((Expression)withStream, ANY_MATCH, new NodeList((Node[])new Expression[]{(Expression)lambdaExpr.get()}));
        IfStmt newif = new IfStmt((Expression)withStream2, (Statement)thenAsBlockStmt, null);
        return this.tryReplace((Node)forEachStmt, (Node)newif);
    }

    public static Optional<LambdaExpr> ifConditionToLambda(IfStmt ifStmt, VariableDeclarator variable) {
        if (LambdaExprHelpers.hasOuterAssignExpr((Node)ifStmt.getCondition())) {
            return Optional.empty();
        }
        Parameter parameter = new Parameter((Type)new UnknownType(), variable.getName());
        Expression condition = ifStmt.getCondition();
        LambdaExpr lambdaExpr = new LambdaExpr(parameter, condition);
        return Optional.of(lambdaExpr);
    }
}

