/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ForEachStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.UnknownType;
import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.ImportDeclarationHelpers;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.helpers.ResolvedTypeHelpers;
import eu.solven.cleanthat.engine.java.refactorer.meta.ApplyAfterMe;
import eu.solven.cleanthat.engine.java.refactorer.mutators.ARefactorConsecutiveStatements;
import eu.solven.cleanthat.engine.java.refactorer.mutators.ForEachIfToIfStreamAnyMatch;
import eu.solven.cleanthat.engine.java.refactorer.mutators.LambdaIsMethodReference;
import eu.solven.cleanthat.engine.java.refactorer.mutators.StreamMutatorHelpers;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

@ApplyAfterMe(value={LambdaIsMethodReference.class})
public class ForEachAddToStreamCollectToCollection
extends ARefactorConsecutiveStatements {
    public String minimalJavaVersion() {
        return "1.8";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Stream", (Object)"Loop");
    }

    @Override
    protected boolean trySimplifyingStatements(NodeAndSymbolSolver<BlockStmt> blockStmtAndSolver, Statement currentStmt, Statement nextStmt) {
        if (currentStmt.isExpressionStmt() && nextStmt.isForEachStmt()) {
            return this.onForEachStmt(blockStmtAndSolver, currentStmt.asExpressionStmt(), nextStmt.asForEachStmt());
        }
        return false;
    }

    private boolean onForEachStmt(NodeAndSymbolSolver<BlockStmt> blockStmtAndSolver, ExpressionStmt asExpressionStmt, ForEachStmt forEachStmt) {
        String maporFlatMap;
        MethodCallExpr streamMayDoFilter;
        Statement thenStmt;
        if (!asExpressionStmt.getExpression().isVariableDeclarationExpr()) {
            return false;
        }
        VariableDeclarationExpr variableDeclarationExpr = asExpressionStmt.getExpression().asVariableDeclarationExpr();
        if (variableDeclarationExpr.getVariables().size() != 1) {
            return false;
        }
        Optional optInitializer = variableDeclarationExpr.getVariable(0).getInitializer();
        if (optInitializer.isEmpty() || !((Expression)optInitializer.get()).isObjectCreationExpr()) {
            return false;
        }
        ObjectCreationExpr objectCreationExpr = ((Expression)optInitializer.get()).asObjectCreationExpr();
        if (!ResolvedTypeHelpers.typeIsAssignable(ResolvedTypeHelpers.optResolvedType((Type)objectCreationExpr.getType()), Collection.class.getName()) || !objectCreationExpr.getArguments().isEmpty()) {
            return false;
        }
        Optional<IfStmt> optIfStmt = StreamMutatorHelpers.findSingleIfThenStmt(forEachStmt);
        if (optIfStmt.isPresent()) {
            thenStmt = optIfStmt.get().getThenStmt();
        } else {
            Optional<Statement> optSingleForEachBodyStmt = StreamMutatorHelpers.findSingleStatement(forEachStmt.getBody());
            if (optSingleForEachBodyStmt.isEmpty()) {
                return false;
            }
            thenStmt = optSingleForEachBodyStmt.get();
        }
        Optional<Statement> optMethodCall = StreamMutatorHelpers.findSingleStatement(thenStmt);
        if (optMethodCall.isEmpty()) {
            return false;
        }
        if (!optMethodCall.get().isExpressionStmt()) {
            return false;
        }
        if (!optMethodCall.get().asExpressionStmt().getExpression().isMethodCallExpr()) {
            return false;
        }
        MethodCallExpr methodCall = optMethodCall.get().asExpressionStmt().getExpression().asMethodCallExpr();
        if (!"add".equals(methodCall.getNameAsString()) && !"addAll".equals(methodCall.getNameAsString())) {
            return false;
        }
        if (methodCall.getScope().isEmpty() || !((Expression)methodCall.getScope().get()).isNameExpr()) {
            return false;
        }
        if (!Objects.equals(((Expression)methodCall.getScope().get()).asNameExpr(), variableDeclarationExpr.getVariable(0).getNameAsExpression())) {
            return false;
        }
        if (methodCall.getArguments().size() != 1) {
            return false;
        }
        Optional<MethodCallExpr> optStream = this.iterableToStream(blockStmtAndSolver, forEachStmt);
        if (optStream.isEmpty()) {
            return false;
        }
        MethodCallExpr stream = optStream.get();
        if (optIfStmt.isPresent()) {
            IfStmt ifStmt = optIfStmt.get();
            Optional<LambdaExpr> filterArgument = ForEachIfToIfStreamAnyMatch.ifConditionToLambda(ifStmt, forEachStmt.getVariable().getVariable(0));
            if (filterArgument.isEmpty()) {
                return false;
            }
            streamMayDoFilter = new MethodCallExpr((Expression)stream, "filter", new NodeList((Node[])new Expression[]{(Expression)filterArgument.get()}));
        } else {
            streamMayDoFilter = stream;
        }
        boolean removedForEach = this.tryRemove((Node)forEachStmt);
        if (!removedForEach) {
            return false;
        }
        Expression added = methodCall.getArgument(0);
        if ("add".equals(methodCall.getNameAsString())) {
            maporFlatMap = "map";
        } else if ("addAll".equals(methodCall.getNameAsString())) {
            maporFlatMap = "flatMap";
            added = new MethodCallExpr(added, "stream");
        } else {
            return false;
        }
        Parameter parameter = new Parameter((Type)new UnknownType(), forEachStmt.getVariableDeclarator().getName());
        MethodCallExpr doMap = new MethodCallExpr((Expression)streamMayDoFilter, maporFlatMap, new NodeList((Node[])new Expression[]{new LambdaExpr(parameter, added)}));
        LambdaExpr collectorLambda = new LambdaExpr(new NodeList(), (Expression)objectCreationExpr);
        MethodCallExpr toCollection = new MethodCallExpr((Expression)new NameExpr("Collectors"), "toCollection", new NodeList((Node[])new Expression[]{collectorLambda}));
        variableDeclarationExpr.getVariable(0).setInitializer((Expression)new MethodCallExpr((Expression)doMap, "collect", new NodeList((Node[])new Expression[]{toCollection})));
        return true;
    }

    private Optional<MethodCallExpr> iterableToStream(NodeAndSymbolSolver<BlockStmt> blockStmtAndSolver, ForEachStmt forEachStmt) {
        Expression iterable = forEachStmt.getIterable();
        if (MethodCallExprHelpers.scopeHasRequiredType(blockStmtAndSolver.editNode(iterable), Collection.class)) {
            return Optional.of(new MethodCallExpr(iterable, "stream"));
        }
        Optional<ResolvedDeclaration> optType = this.optResolved(iterable);
        if (MethodCallExprHelpers.scopeHasRequiredType(blockStmtAndSolver.editNode(iterable), int[].class)) {
            return Optional.empty();
        }
        if (optType.isPresent() && optType.get().isParameter() && optType.get().asParameter().getType().isArray()) {
            NameExpr scope = ImportDeclarationHelpers.nameOrQualifiedName(blockStmtAndSolver, Stream.class);
            return Optional.of(new MethodCallExpr((Expression)scope, "of", new NodeList((Node[])new Expression[]{iterable})));
        }
        return Optional.empty();
    }
}

