/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.ConditionalExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.ImportDeclarationHelpers;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import java.util.List;
import java.util.Set;

public class CollectionToOptional
extends AJavaparserExprMutator {
    public String minimalJavaVersion() {
        return "1.2";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Collection", (Object)"Optional");
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        if (!expr.getNode().isConditionalExpr()) {
            return false;
        }
        ConditionalExpr conditionalExpr = expr.getNode().asConditionalExpr();
        Expression conditionExpr = conditionalExpr.getCondition();
        Expression thenExpr = conditionalExpr.getThenExpr();
        Expression elseExpr = conditionalExpr.getElseExpr();
        if (!(conditionExpr.isMethodCallExpr() && thenExpr.isMethodCallExpr() && elseExpr.isMethodCallExpr())) {
            return false;
        }
        MethodCallExpr conditionMethod = conditionExpr.asMethodCallExpr();
        MethodCallExpr thenMethod = thenExpr.asMethodCallExpr();
        MethodCallExpr elseMethod = elseExpr.asMethodCallExpr();
        if (!"isEmpty".equals(conditionMethod.getNameAsString()) || !MethodCallExprHelpers.scopeHasRequiredType(expr.editNode(conditionMethod.getScope()), List.class)) {
            return false;
        }
        if (!"Optional.empty()".equals(thenMethod.toString()) || !this.hasImported(expr, "java.util.Optional")) {
            return false;
        }
        if (!"Optional.of(list.get(0))".equals(elseMethod.toString())) {
            return false;
        }
        return this.tryReplace((Node)expr.getNode(), (Node)new MethodCallExpr((Expression)new MethodCallExpr((Expression)conditionMethod.getScope().get(), "stream"), "findFirst"));
    }

    private boolean hasImported(NodeAndSymbolSolver<Expression> expr, String imported) {
        return ImportDeclarationHelpers.isImported(expr, imported);
    }
}

