/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.LiteralStringValueExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.resolution.types.ResolvedType;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.BinaryExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.helpers.ResolvedTypeHelpers;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class CastMathOperandsBeforeAssignement
extends AJavaparserExprMutator {
    private static final Set<BinaryExpr.Operator> MATH_NOT_DIVIDE_OPERATORS = Set.of(BinaryExpr.Operator.PLUS, BinaryExpr.Operator.MINUS, BinaryExpr.Operator.MULTIPLY);
    private static final Set<BinaryExpr.Operator> MATH_DIVIDE_OPERATORS = Set.of(BinaryExpr.Operator.DIVIDE);

    public String minimalJavaVersion() {
        return "1";
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-2184");
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Primitive");
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        if (!expr.getNode().isBinaryExpr()) {
            return false;
        }
        BinaryExpr binaryExpr = expr.getNode().asBinaryExpr();
        NodeAndSymbolSolver<BinaryExpr> binaryExprWithContext = expr.editNode(binaryExpr);
        BinaryExpr.Operator operator = binaryExpr.getOperator();
        if (MATH_NOT_DIVIDE_OPERATORS.contains(operator)) {
            return this.onNotDivision(binaryExprWithContext);
        }
        if (MATH_DIVIDE_OPERATORS.contains(operator)) {
            return this.onDivision(binaryExprWithContext);
        }
        return false;
    }

    private boolean onDivision(NodeAndSymbolSolver<BinaryExpr> binaryExprAndSolver) {
        boolean rightIsFloating;
        BinaryExpr binaryExpr = binaryExprAndSolver.getNode();
        boolean leftIsFloating = MethodCallExprHelpers.scopeHasRequiredType(binaryExprAndSolver.editNode(binaryExpr.getLeft()), Float.TYPE) || MethodCallExprHelpers.scopeHasRequiredType(binaryExprAndSolver.editNode(binaryExpr.getLeft()), Double.TYPE);
        boolean bl = rightIsFloating = MethodCallExprHelpers.scopeHasRequiredType(binaryExprAndSolver.editNode(binaryExpr.getRight()), Float.TYPE) || MethodCallExprHelpers.scopeHasRequiredType(binaryExprAndSolver.editNode(binaryExpr.getRight()), Double.TYPE);
        if (leftIsFloating || rightIsFloating) {
            return false;
        }
        if (this.isUsedAsAIntOrLong((Expression)binaryExpr)) {
            return false;
        }
        Optional<PrimitiveType> optFloatOrDouble = this.optFloatOrDoubleUsage((Expression)binaryExpr);
        if (optFloatOrDouble.isEmpty()) {
            return false;
        }
        Optional<Expression> optIntOrLongLiteral = BinaryExprHelpers.findAny(binaryExpr, n -> n.isLiteralStringValueExpr(), true);
        if (optIntOrLongLiteral.isPresent()) {
            LiteralStringValueExpr intOrLongLiteralExpr = optIntOrLongLiteral.get().asLiteralStringValueExpr();
            String suffix = optFloatOrDouble.get().equals((Object)PrimitiveType.floatType()) ? "F" : "D";
            this.tryReplace((Node)intOrLongLiteralExpr, (Node)new DoubleLiteralExpr(intOrLongLiteralExpr.getValue() + suffix));
        } else {
            Expression needToCast = binaryExpr.getLeft();
            CastExpr newLeft = new CastExpr((Type)optFloatOrDouble.get(), needToCast);
            binaryExpr.setLeft((Expression)newLeft);
            needToCast.setParentNode((Node)newLeft);
        }
        return true;
    }

    private boolean onNotDivision(NodeAndSymbolSolver<BinaryExpr> binaryExprAndSolver) {
        BinaryExpr binaryExpr = binaryExprAndSolver.getNode();
        if (!MethodCallExprHelpers.scopeHasRequiredType(binaryExprAndSolver.editNode(binaryExpr.getLeft()), Integer.TYPE)) {
            return false;
        }
        if (!MethodCallExprHelpers.scopeHasRequiredType(binaryExprAndSolver.editNode(binaryExpr.getRight()), Integer.TYPE)) {
            return false;
        }
        if (!this.isUsedAsALong((Expression)binaryExprAndSolver.getNode())) {
            return false;
        }
        Optional<Expression> optBinaryExpr = BinaryExprHelpers.findAny(binaryExpr, n -> n.isBinaryExpr(), true);
        if (optBinaryExpr.isPresent()) {
            return this.processNotRecursively(binaryExprAndSolver.editNode(optBinaryExpr.get()));
        }
        Optional<Expression> optIntegerLiteral = BinaryExprHelpers.findAny(binaryExpr, n -> n.isIntegerLiteralExpr(), true);
        if (optIntegerLiteral.isPresent()) {
            IntegerLiteralExpr intLiteralExpr = optIntegerLiteral.get().asIntegerLiteralExpr();
            this.tryReplace((Node)intLiteralExpr, (Node)new LongLiteralExpr(intLiteralExpr.getValue() + "L"));
        } else {
            binaryExpr.setLeft((Expression)new CastExpr((Type)PrimitiveType.longType(), binaryExpr.getLeft()));
        }
        return true;
    }

    private boolean isUsedAsALong(Expression expr) {
        return this.doMap(expr, optResolvedType -> {
            if (this.typeWouldNotOverflowFromInt((Optional<ResolvedType>)optResolvedType)) {
                return Optional.of("");
            }
            return Optional.empty();
        }).isPresent();
    }

    private boolean typeWouldNotOverflowFromInt(Optional<ResolvedType> optResolvedType) {
        if (ResolvedTypeHelpers.typeIsAssignable(optResolvedType, Integer.TYPE.getName()) || ResolvedTypeHelpers.typeIsAssignable(optResolvedType, Integer.class.getName())) {
            return false;
        }
        return ResolvedTypeHelpers.typeIsAssignable(optResolvedType, Long.TYPE.getName()) || ResolvedTypeHelpers.typeIsAssignable(optResolvedType, Float.TYPE.getName()) || ResolvedTypeHelpers.typeIsAssignable(optResolvedType, Double.TYPE.getName()) || ResolvedTypeHelpers.typeIsAssignable(optResolvedType, Number.class.getName());
    }

    private boolean isIntOrLong(Optional<ResolvedType> optResolvedType) {
        if (optResolvedType.isEmpty()) {
            return false;
        }
        if (optResolvedType.get().isPrimitive()) {
            return ResolvedTypeHelpers.typeIsAssignable(optResolvedType, Integer.TYPE.getName()) || ResolvedTypeHelpers.typeIsAssignable(optResolvedType, Long.TYPE.getName());
        }
        return ResolvedTypeHelpers.typeIsAssignable(optResolvedType, Number.class.getName());
    }

    private boolean isUsedAsAIntOrLong(Expression expr) {
        return this.doMap(expr, optResolvedType -> {
            if (this.isIntOrLong((Optional<ResolvedType>)optResolvedType)) {
                return Optional.of("");
            }
            return Optional.empty();
        }).isPresent();
    }

    private Optional<PrimitiveType> optFloatOrDoubleUsage(Expression expr) {
        return this.doMap(expr, optResolvedType -> {
            if (ResolvedTypeHelpers.typeIsAssignable(optResolvedType, Float.TYPE.getName())) {
                return Optional.of(PrimitiveType.floatType());
            }
            if (ResolvedTypeHelpers.typeIsAssignable(optResolvedType, Double.TYPE.getName())) {
                return Optional.of(PrimitiveType.doubleType());
            }
            return Optional.empty();
        });
    }

    private <T> Optional<T> doMap(Expression expr, Function<Optional<ResolvedType>, Optional<T>> mapper) {
        Class[] classes = new Class[]{AssignExpr.class, CastExpr.class, LambdaExpr.class, ReturnStmt.class, MethodCallExpr.class, ObjectCreationExpr.class};
        Optional optAncestorDefiningType = expr.findAncestor(classes);
        if (optAncestorDefiningType.isEmpty()) {
            return Optional.empty();
        }
        if (optAncestorDefiningType.get() instanceof NodeWithType) {
            NodeWithType castExpr = (NodeWithType)optAncestorDefiningType.get();
            Optional<ResolvedType> optResolvedType = ResolvedTypeHelpers.optResolvedType(castExpr.getType());
            return mapper.apply(optResolvedType);
        }
        if (optAncestorDefiningType.get() instanceof ReturnStmt) {
            ReturnStmt returnStmt = (ReturnStmt)optAncestorDefiningType.get();
            Optional optParentNodeNotBlock = returnStmt.getParentNode();
            while (optParentNodeNotBlock.isPresent() && optParentNodeNotBlock.get() instanceof BlockStmt) {
                optParentNodeNotBlock = ((Node)optParentNodeNotBlock.get()).getParentNode();
            }
            if (optParentNodeNotBlock.isEmpty()) {
                return Optional.empty();
            }
            if (optParentNodeNotBlock.get() instanceof MethodDeclaration) {
                MethodDeclaration methodDecl = (MethodDeclaration)optParentNodeNotBlock.get();
                Optional<ResolvedType> optResolvedType = ResolvedTypeHelpers.optResolvedType(methodDecl.getType());
                return mapper.apply(optResolvedType);
            }
            if (optParentNodeNotBlock.get() instanceof LambdaExpr) {
                return Optional.empty();
            }
            return Optional.empty();
        }
        return Optional.empty();
    }
}

