/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import java.util.Optional;
import java.util.Set;

public class AvoidMultipleUnaryOperators
extends AJavaparserExprMutator {
    private static final Set<UnaryExpr.Operator> REDUNDANT_IF_DOUBLED = ImmutableSet.of((Object)UnaryExpr.Operator.LOGICAL_COMPLEMENT, (Object)UnaryExpr.Operator.MINUS, (Object)UnaryExpr.Operator.PLUS, (Object)UnaryExpr.Operator.BITWISE_COMPLEMENT);

    public String minimalJavaVersion() {
        return "1";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Redundancy");
    }

    public Optional<String> getPmdId() {
        return Optional.of("AvoidMultipleUnaryOperators");
    }

    public String pmdUrl() {
        return "http://adangel.github.io/pmd/pmd_rules_java_errorprone.html#avoidmultipleunaryoperators";
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-2761");
    }

    public Optional<String> getJSparrowId() {
        return Optional.of("RemoveDoubleNegation");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/remove-double-negation.html";
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        if (!expr.getNode().isUnaryExpr()) {
            return false;
        }
        UnaryExpr unaryExpr = expr.getNode().asUnaryExpr();
        UnaryExpr.Operator unaryOperator = unaryExpr.getOperator();
        if (!REDUNDANT_IF_DOUBLED.contains(unaryOperator)) {
            return false;
        }
        if (!unaryExpr.getParentNode().isPresent() || !(unaryExpr.getParentNode().get() instanceof UnaryExpr)) {
            return false;
        }
        UnaryExpr parentUnaryExpr = (UnaryExpr)unaryExpr.getParentNode().get();
        if (parentUnaryExpr.getOperator() != unaryOperator) {
            return false;
        }
        return this.tryReplace((Node)parentUnaryExpr, (Node)unaryExpr.getExpression());
    }
}

