/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer;

import com.github.difflib.DiffUtils;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.DeltaType;
import com.github.difflib.patch.Patch;
import com.github.difflib.patch.PatchFailedException;
import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.printer.lexicalpreservation.LexicalPreservingPrinter;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionClassDeclaration;
import com.github.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.MemoryTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import com.google.common.collect.ImmutableMap;
import eu.solven.cleanthat.engine.java.refactorer.AAstRefactorer;
import eu.solven.cleanthat.engine.java.refactorer.JavaRefactorerProperties;
import eu.solven.cleanthat.engine.java.refactorer.meta.IJavaparserAstMutator;
import eu.solven.cleanthat.engine.java.refactorer.mutators.composite.AllIncludingDraftSingleMutators;
import eu.solven.cleanthat.formatter.LineEnding;
import eu.solven.cleanthat.formatter.PathAndContent;
import eu.solven.cleanthat.language.IEngineProperties;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.codehaus.plexus.languages.java.version.JavaVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaRefactorer
extends AAstRefactorer<Node, JavaParser, Node, IJavaparserAstMutator> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaRefactorer.class);
    public static final boolean JAVAPARSER_JRE_ONLY = true;
    private final IEngineProperties engineProperties;
    private final JavaRefactorerProperties refactorerProperties;

    public static final Set<String> getAllIncluded() {
        return new AllIncludingDraftSingleMutators(JavaVersion.parse((String)"99.999")).getUnderlyingIds();
    }

    public JavaRefactorer(IEngineProperties engineProperties, JavaRefactorerProperties properties) {
        super(JavaRefactorer.filterRules((IEngineProperties)engineProperties, (JavaRefactorerProperties)properties).stream().filter(c -> IJavaparserAstMutator.class.isAssignableFrom(c.getClass())).map(IJavaparserAstMutator.class::cast).collect(Collectors.toList()));
        this.engineProperties = engineProperties;
        this.refactorerProperties = properties;
    }

    public String getId() {
        return "cleanthat";
    }

    @Deprecated(since="Not used anymore. Kept for retrocompatiblity of users (e.g. Spotless)", forRemoval=true)
    public String doFormat(String dirtyCode, LineEnding eol) throws IOException {
        return this.doFormat(dirtyCode);
    }

    public String doFormat(PathAndContent pathAndContent) throws IOException {
        LOGGER.debug("Refactoring conf={}", (Object)this.refactorerProperties);
        String cleanCode = this.applyTransformers(pathAndContent);
        return this.fixJavaparserUnexpectedChanges(pathAndContent.getContent(), cleanCode);
    }

    public Optional<Node> parseSourceCode(JavaParser parser, String sourceCode) {
        ParseResult parsed = parser.parse(sourceCode);
        if (!parsed.isSuccessful()) {
            LOGGER.warn("Issue parsing some source. {} problems. First problem: {}", (Object)parsed.getProblems().size(), (Object)parsed.getProblem(0));
            return Optional.empty();
        }
        CompilationUnit compilationUnit = (CompilationUnit)parsed.getResult().get();
        LexicalPreservingPrinter.setup((Node)compilationUnit);
        return Optional.of(compilationUnit);
    }

    protected JavaParser makeAstParser() {
        boolean isJreOnly = true;
        JavaParser parser = JavaRefactorer.makeDefaultJavaParser(isJreOnly);
        return parser;
    }

    protected String fixJavaparserUnexpectedChanges(String dirtyCode, String cleanCode) throws IOException {
        List fixedPatchApplied;
        if (dirtyCode.equals(cleanCode)) {
            return dirtyCode;
        }
        String lineEndingChars = LineEnding.getOrGuess((LineEnding)this.engineProperties.getSourceCode().getLineEndingAsEnum(), () -> cleanCode);
        Optional optLineEnding = LineEnding.determineLineEnding((String)lineEndingChars);
        if (optLineEnding.isEmpty()) {
            return cleanCode;
        }
        List<String> dirtyRows = Arrays.asList(dirtyCode.split(lineEndingChars, -1));
        List<String> cleanRows = Arrays.asList(cleanCode.split(lineEndingChars, -1));
        Patch diff = DiffUtils.diff(dirtyRows, cleanRows);
        this.assertPatchIsValid(dirtyRows, cleanRows, (Patch<String>)diff);
        List<AbstractDelta<String>> fixedDelta = this.computeFixedDelta((Patch<String>)diff);
        if (fixedDelta.isEmpty()) {
            return dirtyCode;
        }
        Patch fixedPatch = new Patch();
        fixedDelta.forEach(arg_0 -> ((Patch)fixedPatch).addDelta(arg_0));
        try {
            fixedPatchApplied = diff.applyTo(dirtyRows);
        }
        catch (PatchFailedException e) {
            throw new RuntimeException(e);
        }
        return fixedPatchApplied.stream().collect(Collectors.joining(lineEndingChars));
    }

    public List<AbstractDelta<String>> computeFixedDelta(Patch<String> diff) {
        List<AbstractDelta<String>> fixedDelta = diff.getDeltas().stream().filter(p -> {
            if (p.getType() == DeltaType.DELETE) {
                String uniqueTrimmer;
                List sourceLines = p.getSource().getLines();
                Set unique = sourceLines.stream().distinct().collect(Collectors.toSet());
                return unique.size() != 1 || !(uniqueTrimmer = ((String)unique.iterator().next()).trim()).isEmpty() && !"*".equals(uniqueTrimmer);
            }
            return true;
        }).collect(Collectors.toList());
        return fixedDelta;
    }

    protected void assertPatchIsValid(List<String> dirtyRows, List<String> cleanRows, Patch<String> diff) {
        List patchApplied;
        try {
            patchApplied = diff.applyTo(dirtyRows);
        }
        catch (PatchFailedException e) {
            throw new RuntimeException(e);
        }
        if (!cleanRows.equals(patchApplied)) {
            throw new IllegalArgumentException("Issue aplying the patch");
        }
        List patchRestored = diff.restore(cleanRows);
        if (!dirtyRows.equals(patchRestored)) {
            throw new IllegalArgumentException("Issue restoring the patch");
        }
    }

    protected String toString(Node compilationUnit) {
        return LexicalPreservingPrinter.print((Node)compilationUnit);
    }

    public static TypeSolver makeDefaultTypeSolver(boolean jreOnly) {
        if (!jreOnly) {
            LOGGER.warn("We force jreOnly to {}", (Object)true);
            jreOnly = true;
        }
        ReflectionTypeSolver reflectionTypeSolver = new ReflectionTypeSolver(jreOnly);
        MemoryTypeSolver memoryTypeSolver = new MemoryTypeSolver();
        ReflectionClassDeclaration guavaImmutableMap = new ReflectionClassDeclaration(ImmutableMap.class, (TypeSolver)reflectionTypeSolver);
        memoryTypeSolver.addDeclaration(ImmutableMap.class.getName(), (ResolvedReferenceTypeDeclaration)guavaImmutableMap);
        return new CombinedTypeSolver(new TypeSolver[]{reflectionTypeSolver, memoryTypeSolver});
    }

    public static JavaParser makeDefaultJavaParser(boolean jreOnly) {
        return JavaRefactorer.makeDefaultJavaParser(jreOnly, ParserConfiguration.LanguageLevel.BLEEDING_EDGE);
    }

    public static JavaParser makeDefaultJavaParser(boolean jreOnly, ParserConfiguration.LanguageLevel languageLevel) {
        TypeSolver reflectionTypeSolver = JavaRefactorer.makeDefaultTypeSolver(jreOnly);
        JavaSymbolSolver symbolResolver = new JavaSymbolSolver(reflectionTypeSolver);
        ParserConfiguration configuration = new ParserConfiguration().setSymbolResolver((SymbolResolver)symbolResolver).setLanguageLevel(languageLevel);
        JavaParser parser = new JavaParser(configuration);
        return parser;
    }

    protected boolean isValidResultString(JavaParser parser, String resultAsString) {
        return parser.parse(resultAsString).isSuccessful();
    }
}

