/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.script.runtime.data;

import jadx.api.plugins.options.OptionFlag;
import jadx.plugins.script.runtime.data.ScriptOptionDesc;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ%\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017\"\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J \u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00120\u0011R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Ljadx/plugins/script/runtime/data/ScriptOption;", "T", "", "name", "", "id", "optData", "Ljadx/plugins/script/runtime/data/ScriptOptionDesc;", "getter", "Lkotlin/Function0;", "(Ljava/lang/String;Ljava/lang/String;Ljadx/plugins/script/runtime/data/ScriptOptionDesc;Lkotlin/jvm/functions/Function0;)V", "getId", "()Ljava/lang/String;", "getName", "getOptData", "()Ljadx/plugins/script/runtime/data/ScriptOptionDesc;", "validate", "Lkotlin/Function1;", "", "value", "getValue", "()Ljava/lang/Object;", "flags", "", "Ljadx/api/plugins/options/OptionFlag;", "([Ljadx/api/plugins/options/OptionFlag;)Ljadx/plugins/script/runtime/data/ScriptOption;", "predicate", "jadx-script-runtime"})
public final class ScriptOption<T> {
    @NotNull
    private final String name;
    @NotNull
    private final String id;
    @NotNull
    private final ScriptOptionDesc optData;
    @NotNull
    private final Function0<T> getter;
    @Nullable
    private Function1<? super T, Boolean> validate;

    public ScriptOption(@NotNull String name, @NotNull String id, @NotNull ScriptOptionDesc optData, @NotNull Function0<? extends T> getter) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)optData), (String)"optData");
        Intrinsics.checkNotNullParameter(getter, (String)"getter");
        this.name = name;
        this.id = id;
        this.optData = optData;
        this.getter = getter;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final ScriptOptionDesc getOptData() {
        return this.optData;
    }

    public final T getValue() {
        Object v = this.getter.invoke();
        Function1<? super T, Boolean> function1 = this.validate;
        if (function1 != null) {
            Function1<? super T, Boolean> predicate = function1;
            boolean bl = false;
            if (!((Boolean)predicate.invoke(v)).booleanValue()) {
                throw new IllegalArgumentException("Invalid value '" + v + "' for option " + this.id);
            }
        }
        return (T)v;
    }

    @NotNull
    public final ScriptOption<T> validate(@NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        this.validate = predicate;
        return this;
    }

    @NotNull
    public final ScriptOption<T> flags(OptionFlag ... flags) {
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        Set set = this.optData.getFlags();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFlags(...)");
        CollectionsKt.addAll((Collection)set, (Object[])flags);
        return this;
    }
}

