/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.script.runtime;

import io.github.oshai.kotlinlogging.KLogger;
import jadx.api.JadxArgs;
import jadx.api.JadxDecompiler;
import jadx.api.JavaClass;
import jadx.api.plugins.events.IJadxEvents;
import jadx.api.plugins.pass.JadxPass;
import jadx.plugins.script.runtime.JadxScriptData;
import jadx.plugins.script.runtime.data.Debug;
import jadx.plugins.script.runtime.data.Decompile;
import jadx.plugins.script.runtime.data.Gui;
import jadx.plugins.script.runtime.data.JadxScriptOptions;
import jadx.plugins.script.runtime.data.Rename;
import jadx.plugins.script.runtime.data.Replace;
import jadx.plugins.script.runtime.data.Search;
import jadx.plugins.script.runtime.data.Stages;
import java.io.File;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OJ\u0014\u0010P\u001a\u00020M2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020M0RR\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0016\u001a\u00020\u00178FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0015\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001b\u0010!\u001a\u00020\"8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u0015\u001a\u0004\b#\u0010$R\u0011\u0010&\u001a\u00020\u001c8G\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001b\u0010+\u001a\u00020,8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010\u0015\u001a\u0004\b-\u0010.R\u001b\u00100\u001a\u0002018FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010\u0015\u001a\u0004\b2\u00103R\u001b\u00105\u001a\u0002068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b9\u0010\u0015\u001a\u0004\b7\u00108R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010:\u001a\u00020;8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0011\u0010>\u001a\u00020?8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u001b\u0010B\u001a\u00020C8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bF\u0010\u0015\u001a\u0004\bD\u0010ER\u001b\u0010G\u001a\u00020H8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bK\u0010\u0015\u001a\u0004\bI\u0010J\u00a8\u0006S"}, d2={"Ljadx/plugins/script/runtime/JadxScriptInstance;", "", "scriptData", "Ljadx/plugins/script/runtime/JadxScriptData;", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "(Ljadx/plugins/script/runtime/JadxScriptData;Lio/github/oshai/kotlinlogging/KLogger;)V", "args", "Ljadx/api/JadxArgs;", "getArgs", "()Ljadx/api/JadxArgs;", "classes", "", "Ljadx/api/JavaClass;", "getClasses", "()Ljava/util/List;", "debug", "Ljadx/plugins/script/runtime/data/Debug;", "getDebug", "()Ljadx/plugins/script/runtime/data/Debug;", "debug$delegate", "Lkotlin/Lazy;", "decompile", "Ljadx/plugins/script/runtime/data/Decompile;", "getDecompile", "()Ljadx/plugins/script/runtime/data/Decompile;", "decompile$delegate", "decompiler", "Ljadx/api/JadxDecompiler;", "events", "Ljadx/api/plugins/events/IJadxEvents;", "getEvents", "()Ljadx/api/plugins/events/IJadxEvents;", "gui", "Ljadx/plugins/script/runtime/data/Gui;", "getGui", "()Ljadx/plugins/script/runtime/data/Gui;", "gui$delegate", "internalDecompiler", "getInternalDecompiler", "()Ljadx/api/JadxDecompiler;", "getLog", "()Lio/github/oshai/kotlinlogging/KLogger;", "options", "Ljadx/plugins/script/runtime/data/JadxScriptOptions;", "getOptions", "()Ljadx/plugins/script/runtime/data/JadxScriptOptions;", "options$delegate", "rename", "Ljadx/plugins/script/runtime/data/Rename;", "getRename", "()Ljadx/plugins/script/runtime/data/Rename;", "rename$delegate", "replace", "Ljadx/plugins/script/runtime/data/Replace;", "getReplace", "()Ljadx/plugins/script/runtime/data/Replace;", "replace$delegate", "scriptFile", "Ljava/io/File;", "getScriptFile", "()Ljava/io/File;", "scriptName", "", "getScriptName", "()Ljava/lang/String;", "search", "Ljadx/plugins/script/runtime/data/Search;", "getSearch", "()Ljadx/plugins/script/runtime/data/Search;", "search$delegate", "stages", "Ljadx/plugins/script/runtime/data/Stages;", "getStages", "()Ljadx/plugins/script/runtime/data/Stages;", "stages$delegate", "addPass", "", "pass", "Ljadx/api/plugins/pass/JadxPass;", "afterLoad", "block", "Lkotlin/Function0;", "jadx-script-runtime"})
public final class JadxScriptInstance {
    @NotNull
    private final JadxScriptData scriptData;
    @NotNull
    private final KLogger log;
    @NotNull
    private final JadxDecompiler decompiler;
    @NotNull
    private final Lazy options$delegate;
    @NotNull
    private final Lazy rename$delegate;
    @NotNull
    private final Lazy stages$delegate;
    @NotNull
    private final Lazy replace$delegate;
    @NotNull
    private final Lazy decompile$delegate;
    @NotNull
    private final Lazy search$delegate;
    @NotNull
    private final Lazy gui$delegate;
    @NotNull
    private final Lazy debug$delegate;

    public JadxScriptInstance(@NotNull JadxScriptData scriptData, @NotNull KLogger log) {
        Intrinsics.checkNotNullParameter((Object)scriptData, (String)"scriptData");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.scriptData = scriptData;
        this.log = log;
        this.decompiler = this.scriptData.getJadxInstance();
        this.options$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JadxScriptOptions>(this){
            final /* synthetic */ JadxScriptInstance this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final JadxScriptOptions invoke() {
                return new JadxScriptOptions(this.this$0, JadxScriptInstance.access$getScriptData$p(this.this$0).getOptions());
            }
        }));
        this.rename$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Rename>(this){
            final /* synthetic */ JadxScriptInstance this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Rename invoke() {
                return new Rename(this.this$0);
            }
        }));
        this.stages$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Stages>(this){
            final /* synthetic */ JadxScriptInstance this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Stages invoke() {
                return new Stages(this.this$0);
            }
        }));
        this.replace$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Replace>(this){
            final /* synthetic */ JadxScriptInstance this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Replace invoke() {
                return new Replace(this.this$0);
            }
        }));
        this.decompile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Decompile>(this){
            final /* synthetic */ JadxScriptInstance this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Decompile invoke() {
                return new Decompile(this.this$0);
            }
        }));
        this.search$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Search>(this){
            final /* synthetic */ JadxScriptInstance this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Search invoke() {
                return new Search(this.this$0);
            }
        }));
        this.gui$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Gui>(this){
            final /* synthetic */ JadxScriptInstance this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Gui invoke() {
                return new Gui(this.this$0, JadxScriptInstance.access$getScriptData$p(this.this$0).getPluginContext().getGuiContext());
            }
        }));
        this.debug$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Debug>(this){
            final /* synthetic */ JadxScriptInstance this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Debug invoke() {
                return new Debug(this.this$0);
            }
        }));
    }

    @NotNull
    public final KLogger getLog() {
        return this.log;
    }

    @NotNull
    public final JadxScriptOptions getOptions() {
        Lazy lazy = this.options$delegate;
        return (JadxScriptOptions)lazy.getValue();
    }

    @NotNull
    public final Rename getRename() {
        Lazy lazy = this.rename$delegate;
        return (Rename)lazy.getValue();
    }

    @NotNull
    public final Stages getStages() {
        Lazy lazy = this.stages$delegate;
        return (Stages)lazy.getValue();
    }

    @NotNull
    public final Replace getReplace() {
        Lazy lazy = this.replace$delegate;
        return (Replace)lazy.getValue();
    }

    @NotNull
    public final Decompile getDecompile() {
        Lazy lazy = this.decompile$delegate;
        return (Decompile)lazy.getValue();
    }

    @NotNull
    public final Search getSearch() {
        Lazy lazy = this.search$delegate;
        return (Search)lazy.getValue();
    }

    @NotNull
    public final Gui getGui() {
        Lazy lazy = this.gui$delegate;
        return (Gui)lazy.getValue();
    }

    @NotNull
    public final Debug getDebug() {
        Lazy lazy = this.debug$delegate;
        return (Debug)lazy.getValue();
    }

    @NotNull
    public final IJadxEvents getEvents() {
        IJadxEvents iJadxEvents = this.scriptData.getPluginContext().events();
        Intrinsics.checkNotNullExpressionValue((Object)iJadxEvents, (String)"events(...)");
        return iJadxEvents;
    }

    @NotNull
    public final JadxArgs getArgs() {
        JadxArgs jadxArgs = this.decompiler.getArgs();
        Intrinsics.checkNotNullExpressionValue((Object)jadxArgs, (String)"getArgs(...)");
        return jadxArgs;
    }

    @NotNull
    public final List<JavaClass> getClasses() {
        List list = this.decompiler.getClasses();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getClasses(...)");
        return list;
    }

    @NotNull
    public final File getScriptFile() {
        return this.scriptData.getScriptFile();
    }

    @NotNull
    public final String getScriptName() {
        return this.scriptData.getScriptName();
    }

    public final void afterLoad(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.scriptData.getAfterLoad().add(block);
    }

    public final void addPass(@NotNull JadxPass pass) {
        Intrinsics.checkNotNullParameter((Object)pass, (String)"pass");
        this.scriptData.getPluginContext().addPass(pass);
    }

    @ApiStatus.Internal
    @NotNull
    public final JadxDecompiler getInternalDecompiler() {
        return this.decompiler;
    }

    public static final /* synthetic */ JadxScriptData access$getScriptData$p(JadxScriptInstance $this) {
        return $this.scriptData;
    }
}

