/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.script.passes;

import jadx.api.JadxDecompiler;
import jadx.api.plugins.pass.impl.SimpleJadxPassInfo;
import jadx.api.plugins.pass.types.JadxAfterLoadPass;
import jadx.plugins.script.runtime.JadxScriptData;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ljadx/plugins/script/passes/JadxScriptAfterLoadPass;", "Ljadx/api/plugins/pass/types/JadxAfterLoadPass;", "scripts", "", "Ljadx/plugins/script/runtime/JadxScriptData;", "<init>", "(Ljava/util/List;)V", "getInfo", "Ljadx/api/plugins/pass/impl/SimpleJadxPassInfo;", "init", "", "decompiler", "Ljadx/api/JadxDecompiler;", "jadx-script-plugin"})
public final class JadxScriptAfterLoadPass
implements JadxAfterLoadPass {
    @NotNull
    private final List<JadxScriptData> scripts;

    public JadxScriptAfterLoadPass(@NotNull List<JadxScriptData> scripts) {
        Intrinsics.checkNotNullParameter(scripts, (String)"scripts");
        this.scripts = scripts;
    }

    @NotNull
    public SimpleJadxPassInfo getInfo() {
        return new SimpleJadxPassInfo("JadxScriptAfterLoad", "Execute scripts 'afterLoad' block");
    }

    public void init(@NotNull JadxDecompiler decompiler) {
        Intrinsics.checkNotNullParameter((Object)decompiler, (String)"decompiler");
        for (JadxScriptData script : this.scripts) {
            if (script.getError()) continue;
            try {
                for (Function0 b : script.getAfterLoad()) {
                    b.invoke();
                }
            }
            catch (Throwable e) {
                script.setError(true);
                script.getLog().error(e, () -> JadxScriptAfterLoadPass.init$lambda$0(script));
            }
        }
    }

    private static final Object init$lambda$0(JadxScriptData $script) {
        return "Error executing 'afterLoad' block in script: " + $script.getScriptFile().getName();
    }
}

