/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.script;

import jadx.api.plugins.JadxPluginContext;
import jadx.core.utils.files.FileUtils;
import java.io.File;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.CompiledScript;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.jvm.CompiledJvmScriptsCache;
import kotlin.script.experimental.jvm.impl.KJvmCompiledScript;
import kotlin.script.experimental.jvmhost.JvmScriptSavingKt;
import kotlin.script.experimental.util.PropertiesCollection;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0002\f\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ljadx/plugins/script/ScriptCache;", "", "<init>", "()V", "enableCache", "", "build", "Lkotlin/script/experimental/jvm/CompiledJvmScriptsCache;", "context", "Ljadx/api/plugins/JadxPluginContext;", "getCacheDir", "Ljava/io/File;", "JadxScriptsCache", "Companion", "jadx-script-plugin"})
public final class ScriptCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean enableCache = StringsKt.equals((String)System.getProperty("JADX_SCRIPT_CACHE_ENABLE", "true"), (String)"true", (boolean)true);

    @NotNull
    public final CompiledJvmScriptsCache build(@NotNull JadxPluginContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.enableCache) {
            return (CompiledJvmScriptsCache)CompiledJvmScriptsCache.NoCache.INSTANCE;
        }
        return new JadxScriptsCache(this.getCacheDir(context));
    }

    private final File getCacheDir(JadxPluginContext context) {
        File cacheBaseDir = context.files().getPluginCacheDir().resolve("compiled").toFile();
        FileUtils.makeDirs((File)cacheBaseDir);
        Intrinsics.checkNotNull((Object)cacheBaseDir);
        return cacheBaseDir;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\u000e*\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\f\u0010\u0012\u001a\u00020\u0011*\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Ljadx/plugins/script/ScriptCache$Companion;", "", "<init>", "()V", "hashDir", "Ljava/io/File;", "baseCacheDir", "script", "Lkotlin/script/experimental/api/SourceCode;", "hashFile", "cacheDir", "scriptCompilationConfiguration", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "add", "", "Ljava/security/MessageDigest;", "str", "", "toHexString", "", "jadx-script-plugin"})
    @SourceDebugExtension(value={"SMAP\nScriptCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptCache.kt\njadx/plugins/script/ScriptCache$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1056#2:105\n1869#2,2:106\n1#3:108\n*S KotlinDebug\n*F\n+ 1 ScriptCache.kt\njadx/plugins/script/ScriptCache$Companion\n*L\n89#1:105\n90#1:106,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final File hashDir(File baseCacheDir, SourceCode script) {
            if (script.getName() == null && script.getLocationId() == null) {
                return new File(baseCacheDir, "tmp");
            }
            MessageDigest digest = MessageDigest.getInstance("MD5");
            Intrinsics.checkNotNull((Object)digest);
            this.add(digest, script.getName());
            this.add(digest, script.getLocationId());
            byte[] byArray = digest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
            return new File(baseCacheDir, this.toHexString(byArray));
        }

        /*
         * WARNING - void declaration
         */
        private final File hashFile(File cacheDir, SourceCode script, ScriptCompilationConfiguration scriptCompilationConfiguration) {
            void $this$forEach$iv;
            Iterable $this$sortedBy$iv;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            Intrinsics.checkNotNull((Object)digest);
            this.add(digest, script.getText());
            Iterable iterable = scriptCompilationConfiguration.getNotTransientData().entrySet();
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)((PropertiesCollection.Key)it.getKey()).getName());
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((PropertiesCollection.Key)it.getKey()).getName())));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                Companion.add(digest, ((PropertiesCollection.Key)it.getKey()).getName());
                Companion.add(digest, String.valueOf(it.getValue()));
            }
            byte[] byArray = digest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
            return new File(cacheDir, this.toHexString(byArray) + ".jar");
        }

        private final void add(MessageDigest $this$add, String str) {
            block0: {
                String string = str;
                if (string == null) break block0;
                String it = string;
                boolean bl = false;
                byte[] byArray = it.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                $this$add.update(byArray);
            }
        }

        private final String toHexString(byte[] $this$toHexString) {
            return ArraysKt.joinToString$default((byte[])$this$toHexString, (CharSequence)"", null, null, (int)0, null, Companion::toHexString$lambda$3, (int)30, null);
        }

        private static final CharSequence toHexString$lambda$3(byte it) {
            String string = "%02x";
            Object[] objectArray = new Object[]{it};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ljadx/plugins/script/ScriptCache$JadxScriptsCache;", "Lkotlin/script/experimental/jvm/CompiledJvmScriptsCache;", "baseCacheDir", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "get", "Lkotlin/script/experimental/api/CompiledScript;", "script", "Lkotlin/script/experimental/api/SourceCode;", "scriptCompilationConfiguration", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "store", "", "compiledScript", "jadx-script-plugin"})
    public static final class JadxScriptsCache
    implements CompiledJvmScriptsCache {
        @NotNull
        private final File baseCacheDir;

        public JadxScriptsCache(@NotNull File baseCacheDir) {
            Intrinsics.checkNotNullParameter((Object)baseCacheDir, (String)"baseCacheDir");
            this.baseCacheDir = baseCacheDir;
        }

        @Nullable
        public CompiledScript get(@NotNull SourceCode script, @NotNull ScriptCompilationConfiguration scriptCompilationConfiguration) {
            Intrinsics.checkNotNullParameter((Object)script, (String)"script");
            Intrinsics.checkNotNullParameter((Object)scriptCompilationConfiguration, (String)"scriptCompilationConfiguration");
            File cacheDir = Companion.hashDir(this.baseCacheDir, script);
            File file = Companion.hashFile(cacheDir, script, scriptCompilationConfiguration);
            if (!file.exists()) {
                return null;
            }
            CompiledScript compiledScript = JvmScriptSavingKt.loadScriptFromJar$default((File)file, (boolean)false, (int)1, null);
            if (compiledScript == null) {
                JadxScriptsCache $this$get_u24lambda_u240 = this;
                boolean bl = false;
                FileUtils.deleteDir((File)cacheDir);
                compiledScript = null;
            }
            return compiledScript;
        }

        public void store(@NotNull CompiledScript compiledScript, @NotNull SourceCode script, @NotNull ScriptCompilationConfiguration scriptCompilationConfiguration) {
            Intrinsics.checkNotNullParameter((Object)compiledScript, (String)"compiledScript");
            Intrinsics.checkNotNullParameter((Object)script, (String)"script");
            Intrinsics.checkNotNullParameter((Object)scriptCompilationConfiguration, (String)"scriptCompilationConfiguration");
            KJvmCompiledScript kJvmCompiledScript = compiledScript instanceof KJvmCompiledScript ? (KJvmCompiledScript)compiledScript : null;
            if (kJvmCompiledScript == null) {
                throw new IllegalArgumentException("Unsupported script type " + compiledScript.getClass().getName());
            }
            KJvmCompiledScript jvmScript = kJvmCompiledScript;
            File cacheDir = Companion.hashDir(this.baseCacheDir, script);
            File file = Companion.hashFile(cacheDir, script, scriptCompilationConfiguration);
            FilesKt.deleteRecursively((File)cacheDir);
            cacheDir.mkdirs();
            JvmScriptSavingKt.saveToJar((KJvmCompiledScript)jvmScript, (File)file);
        }
    }
}

