/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex;

import jadx.api.plugins.input.data.IClassData;
import jadx.plugins.input.dex.sections.DexClassData;
import jadx.plugins.input.dex.sections.DexHeader;
import jadx.plugins.input.dex.sections.SectionReader;
import jadx.plugins.input.dex.sections.annotations.AnnotationsParser;
import java.nio.ByteBuffer;
import java.util.function.Consumer;

public class DexReader {
    private final int uniqId;
    private final String inputFileName;
    private final ByteBuffer buf;
    private final DexHeader header;

    public DexReader(int uniqId, String inputFileName, byte[] content, int offset) {
        this.uniqId = uniqId;
        this.inputFileName = inputFileName;
        this.buf = ByteBuffer.wrap(content);
        this.header = new DexHeader(new SectionReader(this, offset));
    }

    public void visitClasses(Consumer<IClassData> consumer) {
        int count = this.header.getClassDefsSize();
        if (count == 0) {
            return;
        }
        int classDefsOff = this.header.getClassDefsOff();
        SectionReader in = new SectionReader(this, classDefsOff);
        AnnotationsParser annotationsParser = new AnnotationsParser(in.copy(), in.copy());
        DexClassData classData = new DexClassData(in, annotationsParser);
        for (int i = 0; i < count; ++i) {
            consumer.accept(classData);
            in.shiftOffset(32);
        }
    }

    public ByteBuffer getBuf() {
        return this.buf;
    }

    public DexHeader getHeader() {
        return this.header;
    }

    public String getInputFileName() {
        return this.inputFileName;
    }

    public int getUniqId() {
        return this.uniqId;
    }

    public String toString() {
        return this.inputFileName;
    }
}

