/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex.sections.annotations;

import jadx.api.plugins.input.data.annotations.AnnotationVisibility;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.data.annotations.IAnnotation;
import jadx.api.plugins.input.data.annotations.JadxAnnotation;
import jadx.plugins.input.dex.DexException;
import jadx.plugins.input.dex.sections.SectionReader;
import jadx.plugins.input.dex.sections.annotations.EncodedValueParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AnnotationsParser {
    private final SectionReader in;
    private final SectionReader ext;
    private int offset;
    private int fieldsCount;
    private int methodsCount;
    private int paramsRefCount;

    public AnnotationsParser(SectionReader in, SectionReader ext) {
        this.in = in;
        this.ext = ext;
    }

    public AnnotationsParser copy() {
        return new AnnotationsParser(this.in.copy(), this.ext.copy());
    }

    public void setOffset(int offset) {
        this.offset = offset;
        if (offset == 0) {
            this.fieldsCount = 0;
            this.methodsCount = 0;
            this.paramsRefCount = 0;
        } else {
            this.in.setOffset(offset);
            this.in.pos(4);
            this.fieldsCount = this.in.readInt();
            this.methodsCount = this.in.readInt();
            this.paramsRefCount = this.in.readInt();
        }
    }

    public List<IAnnotation> readClassAnnotations() {
        if (this.offset == 0) {
            return Collections.emptyList();
        }
        int classAnnotationsOffset = this.in.absPos(this.offset).readInt();
        return this.readAnnotationList(classAnnotationsOffset);
    }

    public Map<Integer, Integer> readFieldsAnnotationOffsetMap() {
        if (this.fieldsCount == 0) {
            return Collections.emptyMap();
        }
        this.in.pos(16);
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(this.fieldsCount);
        for (int i = 0; i < this.fieldsCount; ++i) {
            int fieldIdx = this.in.readInt();
            int fieldAnnOffset = this.in.readInt();
            map.put(fieldIdx, fieldAnnOffset);
        }
        return map;
    }

    public Map<Integer, Integer> readMethodsAnnotationOffsetMap() {
        if (this.methodsCount == 0) {
            return Collections.emptyMap();
        }
        this.in.pos(16 + this.fieldsCount * 2 * 4);
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(this.methodsCount);
        for (int i = 0; i < this.methodsCount; ++i) {
            int methodIdx = this.in.readInt();
            int methodAnnOffset = this.in.readInt();
            map.put(methodIdx, methodAnnOffset);
        }
        return map;
    }

    public Map<Integer, Integer> readMethodParamsAnnRefOffsetMap() {
        if (this.paramsRefCount == 0) {
            return Collections.emptyMap();
        }
        this.in.pos(16 + this.fieldsCount * 2 * 4 + this.methodsCount * 2 * 4);
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(this.paramsRefCount);
        for (int i = 0; i < this.paramsRefCount; ++i) {
            int methodIdx = this.in.readInt();
            int methodAnnRefOffset = this.in.readInt();
            map.put(methodIdx, methodAnnRefOffset);
        }
        return map;
    }

    public List<IAnnotation> readAnnotationList(int offset) {
        if (offset == 0) {
            return Collections.emptyList();
        }
        this.in.absPos(offset);
        int size = this.in.readInt();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<IAnnotation> list = new ArrayList<IAnnotation>(size);
        int pos = this.in.getAbsPos();
        for (int i = 0; i < size; ++i) {
            this.in.absPos(pos + i * 4);
            int annOffset = this.in.readInt();
            this.in.absPos(annOffset);
            list.add(AnnotationsParser.readAnnotation(this.in, this.ext, true));
        }
        return list;
    }

    public List<List<IAnnotation>> readAnnotationRefList(int offset) {
        if (offset == 0) {
            return Collections.emptyList();
        }
        this.in.absPos(offset);
        int size = this.in.readInt();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<List<IAnnotation>> list = new ArrayList<List<IAnnotation>>(size);
        for (int i = 0; i < size; ++i) {
            int refOff = this.in.readInt();
            int pos = this.in.getAbsPos();
            list.add(this.readAnnotationList(refOff));
            this.in.absPos(pos);
        }
        return list;
    }

    public static IAnnotation readAnnotation(SectionReader in, SectionReader ext, boolean readVisibility) {
        AnnotationVisibility visibility = null;
        if (readVisibility) {
            int v = in.readUByte();
            visibility = AnnotationsParser.getVisibilityValue(v);
        }
        int typeIndex = in.readUleb128();
        int size = in.readUleb128();
        LinkedHashMap<String, EncodedValue> values = new LinkedHashMap<String, EncodedValue>(size);
        for (int i = 0; i < size; ++i) {
            String name = ext.getString(in.readUleb128());
            values.put(name, EncodedValueParser.parseValue(in, ext));
        }
        String type = ext.getType(typeIndex);
        return new JadxAnnotation(visibility, type, values);
    }

    private static AnnotationVisibility getVisibilityValue(int value) {
        switch (value) {
            case 0: {
                return AnnotationVisibility.BUILD;
            }
            case 1: {
                return AnnotationVisibility.RUNTIME;
            }
            case 2: {
                return AnnotationVisibility.SYSTEM;
            }
        }
        throw new DexException("Unknown annotation visibility value: " + value);
    }

    public EncodedValue parseEncodedValue(SectionReader in) {
        return EncodedValueParser.parseValue(in, this.ext);
    }

    public List<EncodedValue> parseEncodedArray(SectionReader in) {
        return EncodedValueParser.parseEncodedArray(in, this.ext);
    }
}

