/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex.insns;

import jadx.api.plugins.input.insns.InsnIndexType;
import jadx.api.plugins.input.insns.Opcode;
import jadx.plugins.input.dex.insns.DexInsnFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class DexInsnInfo {
    private static final DexInsnInfo[] INSN_INFO;
    private static final Map<Integer, DexInsnInfo> PAYLOAD_INFO;
    private final int opcode;
    private final Opcode apiOpcode;
    private final DexInsnFormat format;
    private final InsnIndexType indexType;

    private static void register(DexInsnInfo[] arr, int opcode, Opcode apiOpcode, DexInsnFormat format) {
        arr[opcode] = new DexInsnInfo(opcode, apiOpcode, format, InsnIndexType.NONE);
    }

    private static void register(DexInsnInfo[] arr, int opcode, Opcode apiOpcode, DexInsnFormat format, InsnIndexType indexType) {
        arr[opcode] = new DexInsnInfo(opcode, apiOpcode, format, indexType);
    }

    private static void registerPayload(int opcode, Opcode apiOpcode, DexInsnFormat format) {
        PAYLOAD_INFO.put(opcode, new DexInsnInfo(opcode, apiOpcode, format, InsnIndexType.NONE));
    }

    @Nullable
    public static DexInsnInfo get(int opcodeUnit) {
        int opcode = opcodeUnit & 0xFF;
        if (opcode == 0 && opcodeUnit != 0) {
            return PAYLOAD_INFO.get(opcodeUnit);
        }
        return INSN_INFO[opcode];
    }

    public DexInsnInfo(int opcode, Opcode apiOpcode, DexInsnFormat format, InsnIndexType indexType) {
        this.opcode = opcode;
        this.apiOpcode = apiOpcode;
        this.format = format;
        this.indexType = indexType;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public Opcode getApiOpcode() {
        return this.apiOpcode;
    }

    public DexInsnFormat getFormat() {
        return this.format;
    }

    public InsnIndexType getIndexType() {
        return this.indexType;
    }

    public String toString() {
        return String.format("0x%X :%d%d", this.opcode, this.format.getLength(), this.format.getRegsCount());
    }

    static {
        DexInsnInfo[] arr = new DexInsnInfo[256];
        INSN_INFO = arr;
        DexInsnInfo.register(arr, 0, Opcode.NOP, DexInsnFormat.FORMAT_10X);
        DexInsnInfo.register(arr, 1, Opcode.MOVE, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 2, Opcode.MOVE, DexInsnFormat.FORMAT_22X);
        DexInsnInfo.register(arr, 3, Opcode.MOVE, DexInsnFormat.FORMAT_32X);
        DexInsnInfo.register(arr, 4, Opcode.MOVE_WIDE, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 5, Opcode.MOVE_WIDE, DexInsnFormat.FORMAT_22X);
        DexInsnInfo.register(arr, 6, Opcode.MOVE_WIDE, DexInsnFormat.FORMAT_32X);
        DexInsnInfo.register(arr, 7, Opcode.MOVE_OBJECT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 8, Opcode.MOVE_OBJECT, DexInsnFormat.FORMAT_22X);
        DexInsnInfo.register(arr, 9, Opcode.MOVE_OBJECT, DexInsnFormat.FORMAT_32X);
        DexInsnInfo.register(arr, 10, Opcode.MOVE_RESULT, DexInsnFormat.FORMAT_11X);
        DexInsnInfo.register(arr, 11, Opcode.MOVE_RESULT, DexInsnFormat.FORMAT_11X);
        DexInsnInfo.register(arr, 12, Opcode.MOVE_RESULT, DexInsnFormat.FORMAT_11X);
        DexInsnInfo.register(arr, 13, Opcode.MOVE_EXCEPTION, DexInsnFormat.FORMAT_11X);
        DexInsnInfo.register(arr, 14, Opcode.RETURN_VOID, DexInsnFormat.FORMAT_10X);
        DexInsnInfo.register(arr, 15, Opcode.RETURN, DexInsnFormat.FORMAT_11X);
        DexInsnInfo.register(arr, 16, Opcode.RETURN, DexInsnFormat.FORMAT_11X);
        DexInsnInfo.register(arr, 17, Opcode.RETURN, DexInsnFormat.FORMAT_11X);
        DexInsnInfo.register(arr, 18, Opcode.CONST, DexInsnFormat.FORMAT_11N);
        DexInsnInfo.register(arr, 19, Opcode.CONST, DexInsnFormat.FORMAT_21S);
        DexInsnInfo.register(arr, 20, Opcode.CONST, DexInsnFormat.FORMAT_31I);
        DexInsnInfo.register(arr, 21, Opcode.CONST, DexInsnFormat.FORMAT_21H);
        DexInsnInfo.register(arr, 22, Opcode.CONST_WIDE, DexInsnFormat.FORMAT_21S);
        DexInsnInfo.register(arr, 23, Opcode.CONST_WIDE, DexInsnFormat.FORMAT_31I);
        DexInsnInfo.register(arr, 24, Opcode.CONST_WIDE, DexInsnFormat.FORMAT_51I);
        DexInsnInfo.register(arr, 25, Opcode.CONST_WIDE, DexInsnFormat.FORMAT_21H);
        DexInsnInfo.register(arr, 26, Opcode.CONST_STRING, DexInsnFormat.FORMAT_21C, InsnIndexType.STRING_REF);
        DexInsnInfo.register(arr, 27, Opcode.CONST_STRING, DexInsnFormat.FORMAT_31C, InsnIndexType.STRING_REF);
        DexInsnInfo.register(arr, 28, Opcode.CONST_CLASS, DexInsnFormat.FORMAT_21C, InsnIndexType.TYPE_REF);
        DexInsnInfo.register(arr, 29, Opcode.MONITOR_ENTER, DexInsnFormat.FORMAT_11X);
        DexInsnInfo.register(arr, 30, Opcode.MONITOR_EXIT, DexInsnFormat.FORMAT_11X);
        DexInsnInfo.register(arr, 31, Opcode.CHECK_CAST, DexInsnFormat.FORMAT_21C, InsnIndexType.TYPE_REF);
        DexInsnInfo.register(arr, 32, Opcode.INSTANCE_OF, DexInsnFormat.FORMAT_22C, InsnIndexType.TYPE_REF);
        DexInsnInfo.register(arr, 33, Opcode.ARRAY_LENGTH, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 34, Opcode.NEW_INSTANCE, DexInsnFormat.FORMAT_21C, InsnIndexType.TYPE_REF);
        DexInsnInfo.register(arr, 35, Opcode.NEW_ARRAY, DexInsnFormat.FORMAT_22C, InsnIndexType.TYPE_REF);
        DexInsnInfo.register(arr, 36, Opcode.FILLED_NEW_ARRAY, DexInsnFormat.FORMAT_35C, InsnIndexType.TYPE_REF);
        DexInsnInfo.register(arr, 37, Opcode.FILLED_NEW_ARRAY_RANGE, DexInsnFormat.FORMAT_3RC, InsnIndexType.TYPE_REF);
        DexInsnInfo.register(arr, 38, Opcode.FILL_ARRAY_DATA, DexInsnFormat.FORMAT_31T);
        DexInsnInfo.register(arr, 39, Opcode.THROW, DexInsnFormat.FORMAT_11X);
        DexInsnInfo.register(arr, 40, Opcode.GOTO, DexInsnFormat.FORMAT_10T);
        DexInsnInfo.register(arr, 41, Opcode.GOTO, DexInsnFormat.FORMAT_20T);
        DexInsnInfo.register(arr, 42, Opcode.GOTO, DexInsnFormat.FORMAT_30T);
        DexInsnInfo.register(arr, 43, Opcode.PACKED_SWITCH, DexInsnFormat.FORMAT_31T);
        DexInsnInfo.register(arr, 44, Opcode.SPARSE_SWITCH, DexInsnFormat.FORMAT_31T);
        DexInsnInfo.register(arr, 45, Opcode.CMPL_FLOAT, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 46, Opcode.CMPG_FLOAT, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 47, Opcode.CMPL_DOUBLE, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 48, Opcode.CMPG_DOUBLE, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 49, Opcode.CMP_LONG, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 50, Opcode.IF_EQ, DexInsnFormat.FORMAT_22T);
        DexInsnInfo.register(arr, 51, Opcode.IF_NE, DexInsnFormat.FORMAT_22T);
        DexInsnInfo.register(arr, 52, Opcode.IF_LT, DexInsnFormat.FORMAT_22T);
        DexInsnInfo.register(arr, 53, Opcode.IF_GE, DexInsnFormat.FORMAT_22T);
        DexInsnInfo.register(arr, 54, Opcode.IF_GT, DexInsnFormat.FORMAT_22T);
        DexInsnInfo.register(arr, 55, Opcode.IF_LE, DexInsnFormat.FORMAT_22T);
        DexInsnInfo.register(arr, 56, Opcode.IF_EQZ, DexInsnFormat.FORMAT_21T);
        DexInsnInfo.register(arr, 57, Opcode.IF_NEZ, DexInsnFormat.FORMAT_21T);
        DexInsnInfo.register(arr, 58, Opcode.IF_LTZ, DexInsnFormat.FORMAT_21T);
        DexInsnInfo.register(arr, 59, Opcode.IF_GEZ, DexInsnFormat.FORMAT_21T);
        DexInsnInfo.register(arr, 60, Opcode.IF_GTZ, DexInsnFormat.FORMAT_21T);
        DexInsnInfo.register(arr, 61, Opcode.IF_LEZ, DexInsnFormat.FORMAT_21T);
        DexInsnInfo.register(arr, 68, Opcode.AGET, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 69, Opcode.AGET_WIDE, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 70, Opcode.AGET_OBJECT, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 71, Opcode.AGET_BOOLEAN, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 72, Opcode.AGET_BYTE, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 73, Opcode.AGET_CHAR, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 74, Opcode.AGET_SHORT, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 75, Opcode.APUT, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 76, Opcode.APUT_WIDE, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 77, Opcode.APUT_OBJECT, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 78, Opcode.APUT_BOOLEAN, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 79, Opcode.APUT_BYTE, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 80, Opcode.APUT_CHAR, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 81, Opcode.APUT_SHORT, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 82, Opcode.IGET, DexInsnFormat.FORMAT_22C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 83, Opcode.IGET, DexInsnFormat.FORMAT_22C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 84, Opcode.IGET, DexInsnFormat.FORMAT_22C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 85, Opcode.IGET, DexInsnFormat.FORMAT_22C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 86, Opcode.IGET, DexInsnFormat.FORMAT_22C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 87, Opcode.IGET, DexInsnFormat.FORMAT_22C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 88, Opcode.IGET, DexInsnFormat.FORMAT_22C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 89, Opcode.IPUT, DexInsnFormat.FORMAT_22C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 90, Opcode.IPUT, DexInsnFormat.FORMAT_22C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 91, Opcode.IPUT, DexInsnFormat.FORMAT_22C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 92, Opcode.IPUT, DexInsnFormat.FORMAT_22C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 93, Opcode.IPUT, DexInsnFormat.FORMAT_22C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 94, Opcode.IPUT, DexInsnFormat.FORMAT_22C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 95, Opcode.IPUT, DexInsnFormat.FORMAT_22C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 96, Opcode.SGET, DexInsnFormat.FORMAT_21C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 97, Opcode.SGET, DexInsnFormat.FORMAT_21C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 98, Opcode.SGET, DexInsnFormat.FORMAT_21C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 99, Opcode.SGET, DexInsnFormat.FORMAT_21C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 100, Opcode.SGET, DexInsnFormat.FORMAT_21C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 101, Opcode.SGET, DexInsnFormat.FORMAT_21C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 102, Opcode.SGET, DexInsnFormat.FORMAT_21C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 103, Opcode.SPUT, DexInsnFormat.FORMAT_21C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 104, Opcode.SPUT, DexInsnFormat.FORMAT_21C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 105, Opcode.SPUT, DexInsnFormat.FORMAT_21C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 106, Opcode.SPUT, DexInsnFormat.FORMAT_21C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 107, Opcode.SPUT, DexInsnFormat.FORMAT_21C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 108, Opcode.SPUT, DexInsnFormat.FORMAT_21C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 109, Opcode.SPUT, DexInsnFormat.FORMAT_21C, InsnIndexType.FIELD_REF);
        DexInsnInfo.register(arr, 110, Opcode.INVOKE_VIRTUAL, DexInsnFormat.FORMAT_35C, InsnIndexType.METHOD_REF);
        DexInsnInfo.register(arr, 111, Opcode.INVOKE_SUPER, DexInsnFormat.FORMAT_35C, InsnIndexType.METHOD_REF);
        DexInsnInfo.register(arr, 112, Opcode.INVOKE_DIRECT, DexInsnFormat.FORMAT_35C, InsnIndexType.METHOD_REF);
        DexInsnInfo.register(arr, 113, Opcode.INVOKE_STATIC, DexInsnFormat.FORMAT_35C, InsnIndexType.METHOD_REF);
        DexInsnInfo.register(arr, 114, Opcode.INVOKE_INTERFACE, DexInsnFormat.FORMAT_35C, InsnIndexType.METHOD_REF);
        DexInsnInfo.register(arr, 116, Opcode.INVOKE_VIRTUAL_RANGE, DexInsnFormat.FORMAT_3RC, InsnIndexType.METHOD_REF);
        DexInsnInfo.register(arr, 117, Opcode.INVOKE_SUPER_RANGE, DexInsnFormat.FORMAT_3RC, InsnIndexType.METHOD_REF);
        DexInsnInfo.register(arr, 118, Opcode.INVOKE_DIRECT_RANGE, DexInsnFormat.FORMAT_3RC, InsnIndexType.METHOD_REF);
        DexInsnInfo.register(arr, 119, Opcode.INVOKE_STATIC_RANGE, DexInsnFormat.FORMAT_3RC, InsnIndexType.METHOD_REF);
        DexInsnInfo.register(arr, 120, Opcode.INVOKE_INTERFACE_RANGE, DexInsnFormat.FORMAT_3RC, InsnIndexType.METHOD_REF);
        DexInsnInfo.register(arr, 123, Opcode.NEG_INT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 124, Opcode.NOT_INT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 125, Opcode.NEG_LONG, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 126, Opcode.NOT_LONG, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 127, Opcode.NEG_FLOAT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 128, Opcode.NEG_DOUBLE, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 129, Opcode.INT_TO_LONG, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 130, Opcode.INT_TO_FLOAT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 131, Opcode.INT_TO_DOUBLE, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 132, Opcode.LONG_TO_INT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 133, Opcode.LONG_TO_FLOAT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 134, Opcode.LONG_TO_DOUBLE, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 135, Opcode.FLOAT_TO_INT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 136, Opcode.FLOAT_TO_LONG, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 137, Opcode.FLOAT_TO_DOUBLE, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 138, Opcode.DOUBLE_TO_INT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 139, Opcode.DOUBLE_TO_LONG, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 140, Opcode.DOUBLE_TO_FLOAT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 141, Opcode.INT_TO_BYTE, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 142, Opcode.INT_TO_CHAR, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 143, Opcode.INT_TO_SHORT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 144, Opcode.ADD_INT, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 145, Opcode.SUB_INT, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 146, Opcode.MUL_INT, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 147, Opcode.DIV_INT, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 148, Opcode.REM_INT, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 149, Opcode.AND_INT, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 150, Opcode.OR_INT, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 151, Opcode.XOR_INT, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 152, Opcode.SHL_INT, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 153, Opcode.SHR_INT, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 154, Opcode.USHR_INT, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 155, Opcode.ADD_LONG, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 156, Opcode.SUB_LONG, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 157, Opcode.MUL_LONG, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 158, Opcode.DIV_LONG, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 159, Opcode.REM_LONG, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 160, Opcode.AND_LONG, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 161, Opcode.OR_LONG, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 162, Opcode.XOR_LONG, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 163, Opcode.SHL_LONG, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 164, Opcode.SHR_LONG, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 165, Opcode.USHR_LONG, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 166, Opcode.ADD_FLOAT, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 167, Opcode.SUB_FLOAT, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 168, Opcode.MUL_FLOAT, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 169, Opcode.DIV_FLOAT, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 170, Opcode.REM_FLOAT, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 171, Opcode.ADD_DOUBLE, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 172, Opcode.SUB_DOUBLE, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 173, Opcode.MUL_DOUBLE, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 174, Opcode.DIV_DOUBLE, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 175, Opcode.REM_DOUBLE, DexInsnFormat.FORMAT_23X);
        DexInsnInfo.register(arr, 176, Opcode.ADD_INT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 177, Opcode.SUB_INT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 178, Opcode.MUL_INT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 179, Opcode.DIV_INT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 180, Opcode.REM_INT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 181, Opcode.AND_INT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 182, Opcode.OR_INT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 183, Opcode.XOR_INT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 184, Opcode.SHL_INT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 185, Opcode.SHR_INT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 186, Opcode.USHR_INT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 187, Opcode.ADD_LONG, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 188, Opcode.SUB_LONG, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 189, Opcode.MUL_LONG, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 190, Opcode.DIV_LONG, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 191, Opcode.REM_LONG, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 192, Opcode.AND_LONG, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 193, Opcode.OR_LONG, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 194, Opcode.XOR_LONG, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 195, Opcode.SHL_LONG, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 196, Opcode.SHR_LONG, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 197, Opcode.USHR_LONG, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 198, Opcode.ADD_FLOAT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 199, Opcode.SUB_FLOAT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 200, Opcode.MUL_FLOAT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 201, Opcode.DIV_FLOAT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 202, Opcode.REM_FLOAT, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 203, Opcode.ADD_DOUBLE, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 204, Opcode.SUB_DOUBLE, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 205, Opcode.MUL_DOUBLE, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 206, Opcode.DIV_DOUBLE, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 207, Opcode.REM_DOUBLE, DexInsnFormat.FORMAT_12X);
        DexInsnInfo.register(arr, 208, Opcode.ADD_INT_LIT, DexInsnFormat.FORMAT_22S);
        DexInsnInfo.register(arr, 209, Opcode.RSUB_INT, DexInsnFormat.FORMAT_22S);
        DexInsnInfo.register(arr, 210, Opcode.MUL_INT_LIT, DexInsnFormat.FORMAT_22S);
        DexInsnInfo.register(arr, 211, Opcode.DIV_INT_LIT, DexInsnFormat.FORMAT_22S);
        DexInsnInfo.register(arr, 212, Opcode.REM_INT_LIT, DexInsnFormat.FORMAT_22S);
        DexInsnInfo.register(arr, 213, Opcode.AND_INT_LIT, DexInsnFormat.FORMAT_22S);
        DexInsnInfo.register(arr, 214, Opcode.OR_INT_LIT, DexInsnFormat.FORMAT_22S);
        DexInsnInfo.register(arr, 215, Opcode.XOR_INT_LIT, DexInsnFormat.FORMAT_22S);
        DexInsnInfo.register(arr, 216, Opcode.ADD_INT_LIT, DexInsnFormat.FORMAT_22B);
        DexInsnInfo.register(arr, 217, Opcode.RSUB_INT, DexInsnFormat.FORMAT_22B);
        DexInsnInfo.register(arr, 218, Opcode.MUL_INT_LIT, DexInsnFormat.FORMAT_22B);
        DexInsnInfo.register(arr, 219, Opcode.DIV_INT_LIT, DexInsnFormat.FORMAT_22B);
        DexInsnInfo.register(arr, 220, Opcode.REM_INT_LIT, DexInsnFormat.FORMAT_22B);
        DexInsnInfo.register(arr, 221, Opcode.AND_INT_LIT, DexInsnFormat.FORMAT_22B);
        DexInsnInfo.register(arr, 222, Opcode.OR_INT_LIT, DexInsnFormat.FORMAT_22B);
        DexInsnInfo.register(arr, 223, Opcode.XOR_INT_LIT, DexInsnFormat.FORMAT_22B);
        DexInsnInfo.register(arr, 224, Opcode.SHL_INT_LIT, DexInsnFormat.FORMAT_22B);
        DexInsnInfo.register(arr, 225, Opcode.SHR_INT_LIT, DexInsnFormat.FORMAT_22B);
        DexInsnInfo.register(arr, 226, Opcode.USHR_INT_LIT, DexInsnFormat.FORMAT_22B);
        DexInsnInfo.register(arr, 250, Opcode.INVOKE_POLYMORPHIC, DexInsnFormat.FORMAT_45CC);
        DexInsnInfo.register(arr, 251, Opcode.INVOKE_POLYMORPHIC_RANGE, DexInsnFormat.FORMAT_4RCC);
        DexInsnInfo.register(arr, 252, Opcode.INVOKE_CUSTOM, DexInsnFormat.FORMAT_35C, InsnIndexType.CALL_SITE);
        DexInsnInfo.register(arr, 253, Opcode.INVOKE_CUSTOM_RANGE, DexInsnFormat.FORMAT_3RC, InsnIndexType.CALL_SITE);
        DexInsnInfo.register(arr, 254, Opcode.CONST_METHOD_HANDLE, DexInsnFormat.FORMAT_21C);
        DexInsnInfo.register(arr, 255, Opcode.CONST_METHOD_TYPE, DexInsnFormat.FORMAT_21C);
        PAYLOAD_INFO = new ConcurrentHashMap<Integer, DexInsnInfo>(3);
        DexInsnInfo.registerPayload(256, Opcode.PACKED_SWITCH_PAYLOAD, DexInsnFormat.FORMAT_PACKED_SWITCH_PAYLOAD);
        DexInsnInfo.registerPayload(512, Opcode.SPARSE_SWITCH_PAYLOAD, DexInsnFormat.FORMAT_SPARSE_SWITCH_PAYLOAD);
        DexInsnInfo.registerPayload(768, Opcode.FILL_ARRAY_DATA_PAYLOAD, DexInsnFormat.FORMAT_FILL_ARRAY_DATA_PAYLOAD);
    }
}

