/*
 * Decompiled with CFR 0.152.
 */
package io.github.sharelison.jsontojava.converter.factory;

import io.github.sharelison.jsontojava.converter.AbstractJsonConverter;
import io.github.sharelison.jsontojava.converter.FileJsonConverter;
import io.github.sharelison.jsontojava.converter.JsonConverter;
import io.github.sharelison.jsontojava.converter.StringJsonConverter;
import io.github.sharelison.jsontojava.file.FileReader;
import io.github.sharelison.jsontojava.validator.JsonTypeChecker;
import io.github.sharelison.jsontojava.validator.JsonValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class JsonConverterFactory {
    private final FileReader fileReader;
    private final JsonValidator jsonValidator;
    private final JsonTypeChecker jsonTypeChecker;
    private Set<String> supportedExtensions = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("json", "txt")));

    public JsonConverterFactory(FileReader fileReader, JsonValidator jsonValidator, JsonTypeChecker jsonTypeChecker) {
        this.fileReader = fileReader;
        this.jsonValidator = jsonValidator;
        this.jsonTypeChecker = jsonTypeChecker;
    }

    public JsonConverter createJsonConverter(String json) {
        AbstractJsonConverter jsonConverter = this.hasExtension(json) ? new FileJsonConverter(this.fileReader, this.jsonValidator, this.jsonTypeChecker) : new StringJsonConverter(this.jsonValidator, this.jsonTypeChecker);
        return jsonConverter;
    }

    private boolean hasExtension(String json) {
        String extension = json.substring(json.lastIndexOf(46) + 1);
        return !extension.isEmpty() && this.supportedExtensions.contains(extension);
    }
}

