/*
 * Decompiled with CFR 0.152.
 */
package io.github.sharelison.jsontojava.converter.builder;

import io.github.sharelison.jsontojava.converter.builder.enums.ComplexPropertyType;
import io.github.sharelison.jsontojava.exception.JsonToJavaException;
import java.util.HashSet;

public class JavaClassBuilder {
    private static final char END_STATEMENT = ';';
    private static final String NEW_LINE = System.lineSeparator();
    private static final String SPACE = " ";
    private static final String BIG_SPACE = "    ";
    private static final String DOUBLE_NEW_LINE = System.lineSeparator() + System.lineSeparator();
    private static final char BLOCK_OPEN = '{';
    private static final char BLOCK_CLOSED = '}';
    private static final String METHOD_NO_ARGS = "()";
    private static final char METHOD_OPEN = '(';
    private static final char METHOD_CLOSED = ')';
    private static final String JSONPROPERTY_IMPORT_STATEMENT = "com.fasterxml.jackson.annotation.JsonProperty";
    private String javaClassDeclaration;
    private StringBuilder properties;
    private StringBuilder gettersAndSetters;
    private StringBuilder importStatements;
    private HashSet<String> importedClasses;
    private HashSet<String> propertyKeyNames;
    private String className;
    private boolean withAnnotations = true;

    public JavaClassBuilder(String className, String packagename) {
        this.validClassNameAndPackageName(className, packagename);
        this.declareClass(JavaClassBuilder.firstCharToUpperCase(className), packagename);
        this.properties = new StringBuilder();
        this.gettersAndSetters = new StringBuilder();
        this.importStatements = new StringBuilder();
        this.importedClasses = new HashSet();
        this.propertyKeyNames = new HashSet();
        this.addImportStatement(JSONPROPERTY_IMPORT_STATEMENT);
    }

    public JavaClassBuilder(String className, String packagename, boolean withAnnotations) {
        this.validClassNameAndPackageName(className, packagename);
        this.declareClass(JavaClassBuilder.firstCharToUpperCase(className), packagename);
        this.withAnnotations = withAnnotations;
        this.properties = new StringBuilder();
        this.gettersAndSetters = new StringBuilder();
        this.importStatements = new StringBuilder();
        this.importedClasses = new HashSet();
        this.propertyKeyNames = new HashSet();
        if (this.withAnnotations) {
            this.addImportStatement(JSONPROPERTY_IMPORT_STATEMENT);
        }
    }

    private void validClassNameAndPackageName(String className, String packagename) {
        if (className == null || className.isEmpty() || packagename == null || packagename.isEmpty()) {
            throw new JsonToJavaException("Class name or package name is empty");
        }
    }

    public String build() {
        String actualImportStatements = this.importStatements.length() == 0 ? "" : this.importStatements.toString() + NEW_LINE;
        return String.format(this.javaClassDeclaration, actualImportStatements, this.properties.toString(), this.gettersAndSetters.toString());
    }

    public String getClassName() {
        return this.className;
    }

    public void addProperty(String originalPropertyName, String declareName) {
        String propertyName = this.removeUnwantedCharacters(originalPropertyName);
        if (!this.propertyKeyNames.contains(propertyName)) {
            this.appendAnnotations(originalPropertyName);
            this.properties.append(BIG_SPACE).append("private ").append(declareName).append(SPACE).append(propertyName).append(';').append(NEW_LINE);
            this.addGettersAndSetters(propertyName, declareName);
            this.propertyKeyNames.add(propertyName);
        }
    }

    private void appendAnnotations(String originalPropertyName) {
        if (this.withAnnotations) {
            this.properties.append(BIG_SPACE).append("@JsonProperty(\"").append(originalPropertyName).append("\"").append(')').append(NEW_LINE);
        }
    }

    public void addProperty(String originalPropertyName, ComplexPropertyType complexPropertyType, String genericType) {
        String propertyName = this.removeUnwantedCharacters(originalPropertyName);
        if (!this.propertyKeyNames.contains(propertyName)) {
            String declareName = String.format(complexPropertyType.getDeclareName(), genericType);
            this.appendAnnotations(originalPropertyName);
            this.properties.append(BIG_SPACE).append("private ").append(declareName).append(SPACE).append(propertyName).append(';').append(NEW_LINE);
            this.addGettersAndSetters(propertyName, declareName);
            this.propertyKeyNames.add(propertyName);
        }
    }

    public void addImportStatement(String importStatement) {
        if (!this.importedClasses.contains(importStatement)) {
            this.importStatements.append("import ").append(importStatement).append(';').append(NEW_LINE);
            this.importedClasses.add(importStatement);
        }
    }

    public boolean hasProperty(String propertyName) {
        return this.propertyKeyNames.contains(propertyName);
    }

    public static String firstCharToUpperCase(String propertyName) {
        return propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
    }

    private void declareClass(String className, String packagename) {
        this.className = this.removeUnwantedCharacters(className);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("package ").append(packagename).append(';').append(DOUBLE_NEW_LINE).append("%s").append("public class ").append(this.className).append(SPACE).append('{').append(DOUBLE_NEW_LINE).append("%s").append(NEW_LINE).append("%s").append('}');
        this.javaClassDeclaration = stringBuilder.toString();
    }

    private void addGettersAndSetters(String propertyName, String propertyType) {
        String firstUpperProperty = JavaClassBuilder.firstCharToUpperCase(propertyName);
        this.gettersAndSetters.append(BIG_SPACE).append("public ").append(propertyType).append(SPACE).append("get").append(firstUpperProperty).append(METHOD_NO_ARGS).append('{').append(NEW_LINE).append(BIG_SPACE).append(BIG_SPACE).append("return this.").append(propertyName).append(';').append(NEW_LINE).append(BIG_SPACE).append('}').append(DOUBLE_NEW_LINE);
        this.gettersAndSetters.append(BIG_SPACE).append("public void").append(SPACE).append("set").append(firstUpperProperty).append('(').append(propertyType).append(SPACE).append(propertyName).append(')').append('{').append(NEW_LINE).append(BIG_SPACE).append(BIG_SPACE).append("this.").append(propertyName).append(" = ").append(propertyName).append(';').append(NEW_LINE).append(BIG_SPACE).append('}').append(DOUBLE_NEW_LINE);
    }

    private String removeUnwantedCharacters(String javaIdentifier) {
        StringBuilder validJavaIdentifier = new StringBuilder();
        char[] givenClassChars = javaIdentifier.toCharArray();
        for (int i = 0; i < givenClassChars.length; ++i) {
            char character = givenClassChars[i];
            if (!Character.isJavaIdentifierPart(character)) continue;
            if (i == 0) {
                if (!Character.isJavaIdentifierStart(character)) continue;
                validJavaIdentifier.append(character);
                continue;
            }
            validJavaIdentifier.append(character);
        }
        if (validJavaIdentifier.length() == 0) {
            throw new JsonToJavaException("No valid characters in class name or property name");
        }
        return validJavaIdentifier.toString();
    }
}

