/*
 * Decompiled with CFR 0.152.
 */
package io.github.sharelison.jsontojava.converter;

import io.github.sharelison.jsontojava.converter.JsonClassResult;
import io.github.sharelison.jsontojava.converter.JsonConverter;
import io.github.sharelison.jsontojava.converter.builder.JavaClassBuilder;
import io.github.sharelison.jsontojava.converter.builder.enums.ComplexPropertyType;
import io.github.sharelison.jsontojava.converter.builder.enums.PropertyType;
import io.github.sharelison.jsontojava.converter.builder.enums.SinglePropertyType;
import io.github.sharelison.jsontojava.converter.builder.enums.util.PropertyTypeFinder;
import io.github.sharelison.jsontojava.exception.JsonToJavaException;
import io.github.sharelison.jsontojava.validator.JsonTypeChecker;
import io.github.sharelison.jsontojava.validator.JsonValidator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class AbstractJsonConverter
implements JsonConverter {
    protected abstract JsonValidator jsonValidator();

    protected abstract JsonTypeChecker jsonTypeChecker();

    protected List<JsonClassResult> convertJsonToJava(String json, String objectName, String packageName, boolean withAnnotations) {
        if (this.jsonValidator().isValidJson(json)) {
            HashMap<String, JavaClassBuilder> javaClasses = new HashMap<String, JavaClassBuilder>();
            this.convert(javaClasses, json, objectName, packageName, withAnnotations);
            return javaClasses.values().stream().map(jcb -> new JsonClassResult(jcb.getClassName(), jcb.build())).collect(Collectors.toList());
        }
        throw new JsonToJavaException("JSON Schema is not valid");
    }

    private JavaClassBuilder convert(Map<String, JavaClassBuilder> javaClasses, String json, String objectName, String packageName, boolean withAnnotations) {
        JavaClassBuilder javaClassBuilder = null;
        if (this.jsonTypeChecker().isObject(json)) {
            javaClassBuilder = this.convertObject(javaClasses, new JSONObject(json), objectName, packageName, withAnnotations);
        } else if (this.jsonTypeChecker().isArray(json)) {
            javaClassBuilder = this.convertArray(javaClasses, new JSONArray(json), objectName, packageName, withAnnotations);
        }
        return javaClassBuilder;
    }

    private JavaClassBuilder convertObject(Map<String, JavaClassBuilder> javaClasses, JSONObject jsonObject, String objectName, String packageName, boolean withAnnotations) {
        JavaClassBuilder javaClassBuilder = javaClasses.keySet().contains(objectName) ? javaClasses.get(objectName) : new JavaClassBuilder(objectName, packageName, withAnnotations);
        javaClasses.put(objectName, javaClassBuilder);
        for (String key : jsonObject.keySet()) {
            Object value = jsonObject.get(key);
            if (value != null && (value instanceof String || !"null".equals(value.toString()))) {
                PropertyType propertyType = PropertyTypeFinder.getPropertyType(value, this.jsonTypeChecker());
                if (!SinglePropertyType.NEW.equals(propertyType)) {
                    if (javaClassBuilder.hasProperty(key)) continue;
                    this.addProperty(javaClasses, javaClassBuilder, key, propertyType, value, packageName, withAnnotations);
                    continue;
                }
                JavaClassBuilder propertyJavaNewClass = this.convert(javaClasses, value.toString(), JavaClassBuilder.firstCharToUpperCase(key), packageName, withAnnotations);
                javaClassBuilder.addProperty(key, propertyJavaNewClass.getClassName());
                continue;
            }
            javaClassBuilder.addProperty(key, SinglePropertyType.OBJECT.getDeclareName());
        }
        return javaClassBuilder;
    }

    private JavaClassBuilder convertArray(Map<String, JavaClassBuilder> javaClasses, JSONArray jsonArray, String objectName, String packageName, boolean withAnnotations) {
        JavaClassBuilder javaClassBuilder = null;
        for (int i = 0; i < jsonArray.length(); ++i) {
            javaClassBuilder = this.convert(javaClasses, jsonArray.get(i).toString(), objectName, packageName, withAnnotations);
        }
        return javaClassBuilder;
    }

    private void addProperty(Map<String, JavaClassBuilder> javaClasses, JavaClassBuilder javaClassBuilder, String key, PropertyType propertyType, Object value, String packageName, boolean withAnnotations) {
        if (propertyType instanceof ComplexPropertyType) {
            ComplexPropertyType complexPropertyType = (ComplexPropertyType)propertyType;
            javaClassBuilder.addProperty(key, complexPropertyType, this.findGenericForList(javaClasses, key, value, packageName, withAnnotations));
            if (complexPropertyType.hasToImport()) {
                javaClassBuilder.addImportStatement(complexPropertyType.getFqName());
            }
        } else {
            javaClassBuilder.addProperty(key, propertyType.getDeclareName());
        }
    }

    protected String findGenericForList(Map<String, JavaClassBuilder> javaClasses, String key, Object value, String packageName, boolean withAnnotations) {
        String type = SinglePropertyType.OBJECT.getDeclareName();
        HashSet<String> types = new HashSet<String>();
        JSONArray jsonArray = new JSONArray(value.toString());
        for (int i = 0; i < jsonArray.length(); ++i) {
            PropertyType propertyType = PropertyTypeFinder.getPropertyType(jsonArray.get(i), this.jsonTypeChecker());
            if (SinglePropertyType.NEW.equals(propertyType)) {
                String className = JavaClassBuilder.firstCharToUpperCase(key);
                this.convert(javaClasses, value.toString(), className, packageName, withAnnotations);
                types.add(className);
                continue;
            }
            types.add(propertyType.getDeclareName());
            if (types.size() <= 1) continue;
            return type;
        }
        if (types.size() == 1) {
            type = (String)types.iterator().next();
        }
        return type;
    }
}

