/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.slimvalidator;

import io.github.sashirestela.slimvalidator.ConstraintValidator;
import io.github.sashirestela.slimvalidator.ConstraintViolation;
import io.github.sashirestela.slimvalidator.ValidationContext;
import io.github.sashirestela.slimvalidator.exception.ValidationException;
import io.github.sashirestela.slimvalidator.metadata.ClassMetadata;
import io.github.sashirestela.slimvalidator.metadata.MetadataStore;
import io.github.sashirestela.slimvalidator.util.Common;
import io.github.sashirestela.slimvalidator.util.Node;
import io.github.sashirestela.slimvalidator.util.Reflect;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class Validator {
    public <T> List<ConstraintViolation> validate(T object) {
        ValidationContext context = new ValidationContext();
        this.validateObject(object, context, new Node());
        return context.getViolations();
    }

    private void validateObject(Object object, ValidationContext context, Node node) {
        if (Common.isPrimitiveOrWrapper(object)) {
            return;
        }
        context.visit(object);
        Class<?> clazz = object.getClass();
        ClassMetadata classMetadata = MetadataStore.one().get(clazz);
        this.validateClassLevel(classMetadata, object, context, node);
        for (ClassMetadata.FieldMetadata fieldMetadata : classMetadata.getFields()) {
            this.validateFieldLevel(fieldMetadata, object, context, node);
        }
    }

    private void validateClassLevel(ClassMetadata classMetadata, Object object, ValidationContext context, Node node) {
        for (ClassMetadata.AnnotationMetadata annotationMetadata : classMetadata.getAnnotations()) {
            Annotation annotation;
            Optional<ConstraintViolation> violationOptional = this.validateAnnotation(annotationMetadata, annotation = annotationMetadata.getAnnotation(), object, this.pathName(node));
            if (!violationOptional.isPresent()) continue;
            context.addViolation(violationOptional.get());
        }
    }

    private String pathName(Node node) {
        String nodeStr = node.toString();
        return nodeStr.isBlank() ? "" : "in ".concat(nodeStr);
    }

    private void validateFieldLevel(ClassMetadata.FieldMetadata fieldMetadata, Object object, ValidationContext context, Node node) {
        String fieldName = fieldMetadata.getName();
        Object fieldValue = Reflect.getValue(object, fieldName);
        for (ClassMetadata.AnnotationMetadata annotationMetadata : fieldMetadata.getAnnotations()) {
            Annotation annotation;
            Optional<ConstraintViolation> violationOptional = this.validateAnnotation(annotationMetadata, annotation = annotationMetadata.getAnnotation(), fieldValue, node.child(fieldName).toString());
            if (!violationOptional.isPresent()) continue;
            context.addViolation(violationOptional.get());
        }
        if (context.isVisited(fieldValue) || fieldValue == null) {
            return;
        }
        if (fieldValue instanceof Collection) {
            int i = 0;
            for (Object item : (Collection)fieldValue) {
                this.validateObject(item, context, node.child(fieldName).child(String.valueOf(i++)));
            }
        } else if (fieldValue instanceof Map) {
            for (Map.Entry entry : ((Map)fieldValue).entrySet()) {
                this.validateObject(entry.getValue(), context, node.child(fieldName).child(entry.getKey().toString()));
            }
        } else if (fieldValue.getClass().isArray()) {
            int i = 0;
            for (Object item : (Object[])fieldValue) {
                this.validateObject(item, context, node.child(fieldName).child(String.valueOf(i++)));
            }
        } else {
            this.validateObject(fieldValue, context, node.child(fieldName));
        }
    }

    private <A extends Annotation, T> Optional<ConstraintViolation> validateAnnotation(ClassMetadata.AnnotationMetadata annotationMetadata, A annotation, T value, String pathName) {
        Class<? extends ConstraintValidator> constraintValidatorClass = annotationMetadata.getValidatedBy();
        if (constraintValidatorClass == null) {
            return Optional.empty();
        }
        try {
            ConstraintValidator constraintValidator = constraintValidatorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            constraintValidator.initialize(annotation);
            if (constraintValidator.isValid(value)) {
                return Optional.empty();
            }
            String message = constraintValidator.getMessage();
            return Optional.of(new ConstraintViolation(value, pathName, message));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ValidationException("Cannot instantiate the class {0}.", constraintValidatorClass.getSimpleName(), e);
        }
    }
}

