/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import io.github.sashirestela.openai.domain.chat.tool.ChatFunction;
import io.github.sashirestela.openai.support.JsonSchemaUtil;
import io.github.sashirestela.slimvalidator.constraints.Required;
import io.github.sashirestela.slimvalidator.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AssistantFunction {
    private String description;
    @Required
    @Size(max=64)
    private String name;
    @Required
    private JsonNode parameters;

    public static AssistantFunction function(ChatFunction function) {
        return AssistantFunction.builder().name(function.getName()).description(function.getDescription()).parameters(JsonSchemaUtil.classToJsonSchema(function.getFunctionalClass())).build();
    }

    public static AssistantFunctionBuilder builder() {
        return new AssistantFunctionBuilder();
    }

    public AssistantFunction(String description, String name, JsonNode parameters) {
        this.description = description;
        this.name = name;
        this.parameters = parameters;
    }

    public AssistantFunction() {
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public JsonNode getParameters() {
        return this.parameters;
    }

    public String toString() {
        return "AssistantFunction(description=" + this.getDescription() + ", name=" + this.getName() + ", parameters=" + this.getParameters() + ")";
    }

    public static class AssistantFunctionBuilder {
        private String description;
        private String name;
        private JsonNode parameters;

        AssistantFunctionBuilder() {
        }

        public AssistantFunctionBuilder description(String description) {
            this.description = description;
            return this;
        }

        public AssistantFunctionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AssistantFunctionBuilder parameters(JsonNode parameters) {
            this.parameters = parameters;
            return this;
        }

        public AssistantFunction build() {
            return new AssistantFunction(this.description, this.name, this.parameters);
        }

        public String toString() {
            return "AssistantFunction.AssistantFunctionBuilder(description=" + this.description + ", name=" + this.name + ", parameters=" + this.parameters + ")";
        }
    }
}

