/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.support;

import io.github.sashirestela.cleverclient.ResponseInfo;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Optional;

public class CleverClientException
extends RuntimeException {
    private final ResponseInfo responseInfo;

    public CleverClientException(String message) {
        super(message);
        this.responseInfo = null;
    }

    public CleverClientException(Throwable cause) {
        super(cause);
        this.responseInfo = null;
    }

    public CleverClientException(String message, Object ... parameters) {
        super(MessageFormat.format(message, Arrays.copyOfRange(parameters, 0, parameters.length - 1)), (Throwable)parameters[parameters.length - 1]);
        this.responseInfo = null;
    }

    public CleverClientException(ResponseInfo responseInfo) {
        super(MessageFormat.format("HTTP interaction failed: server returned a {0} response status.", responseInfo.getStatusCode()), null);
        this.responseInfo = responseInfo;
    }

    public Optional<ResponseInfo> responseInfo() {
        return Optional.ofNullable(this.responseInfo);
    }
}

