/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.websocket;

import io.github.sashirestela.cleverclient.support.CleverClientException;
import io.github.sashirestela.cleverclient.websocket.WebSocketAdapter;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaHttpWebSocketAdapter
extends WebSocketAdapter {
    private static final Logger logger = LoggerFactory.getLogger(JavaHttpWebSocketAdapter.class);
    private HttpClient httpClient;
    private WebSocket webSocket;
    private final StringBuilder dataBuffer = new StringBuilder();
    private CompletableFuture<Void> sendFuture;
    private CompletableFuture<Void> closeFuture;

    public JavaHttpWebSocketAdapter(HttpClient httpClient) {
        this.httpClient = httpClient;
        logger.debug("Created JavaHttpWebSocketAdapter");
    }

    public JavaHttpWebSocketAdapter() {
        this(HttpClient.newHttpClient());
    }

    @Override
    public CompletableFuture<Void> connect(String url, Map<String, String> headers) {
        logger.debug("Connecting to WebSocket URL: {}", (Object)url);
        logger.debug("Connection headers: {}", headers);
        WebSocket.Builder builder = this.httpClient.newWebSocketBuilder();
        headers.forEach(builder::header);
        final CompletableFuture<Void> connectFuture = new CompletableFuture<Void>();
        builder.buildAsync(URI.create(url), new WebSocket.Listener(){

            @Override
            public void onOpen(WebSocket webSocket) {
                JavaHttpWebSocketAdapter.this.webSocket = webSocket;
                logger.debug("WebSocket connection established");
                if (JavaHttpWebSocketAdapter.this.openCallback != null) {
                    JavaHttpWebSocketAdapter.this.openCallback.execute();
                }
                connectFuture.complete(null);
                webSocket.request(1L);
            }

            @Override
            public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
                logger.trace("Received text data chunk, last={}", (Object)last);
                JavaHttpWebSocketAdapter.this.dataBuffer.append(data);
                if (last) {
                    if (JavaHttpWebSocketAdapter.this.messageCallback != null) {
                        String completeMessage = JavaHttpWebSocketAdapter.this.dataBuffer.toString();
                        logger.debug("Received message: {}", (Object)completeMessage);
                        JavaHttpWebSocketAdapter.this.messageCallback.accept(completeMessage);
                    }
                    JavaHttpWebSocketAdapter.this.dataBuffer.setLength(0);
                    if (JavaHttpWebSocketAdapter.this.sendFuture != null) {
                        JavaHttpWebSocketAdapter.this.sendFuture.complete(null);
                        JavaHttpWebSocketAdapter.this.sendFuture = null;
                    }
                }
                webSocket.request(1L);
                return CompletableFuture.completedFuture(null);
            }

            @Override
            public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
                logger.debug("WebSocket closing with code: {}, reason: {}", (Object)statusCode, (Object)reason);
                if (JavaHttpWebSocketAdapter.this.closeCallback != null) {
                    JavaHttpWebSocketAdapter.this.closeCallback.accept(statusCode, reason);
                }
                if (JavaHttpWebSocketAdapter.this.closeFuture != null) {
                    JavaHttpWebSocketAdapter.this.closeFuture.complete(null);
                }
                return CompletableFuture.completedFuture(null);
            }

            @Override
            public void onError(WebSocket webSocket, Throwable error) {
                logger.error("WebSocket error occurred", error);
                if (JavaHttpWebSocketAdapter.this.errorCallback != null) {
                    JavaHttpWebSocketAdapter.this.errorCallback.accept(error);
                }
                if (JavaHttpWebSocketAdapter.this.sendFuture != null) {
                    JavaHttpWebSocketAdapter.this.sendFuture.completeExceptionally(error);
                }
                if (JavaHttpWebSocketAdapter.this.closeFuture != null) {
                    JavaHttpWebSocketAdapter.this.closeFuture.completeExceptionally(error);
                }
                connectFuture.completeExceptionally(error);
            }
        });
        return connectFuture;
    }

    @Override
    public CompletableFuture<Void> send(String message) {
        if (this.webSocket == null) {
            logger.error("Attempt to send message before WebSocket connection is established");
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(new CleverClientException("WebSocket is not connected"));
            return future;
        }
        logger.debug("Sending message: {}", (Object)message);
        this.sendFuture = new CompletableFuture();
        this.webSocket.sendText(message, true);
        return this.sendFuture;
    }

    @Override
    public void close() {
        block3: {
            if (this.webSocket != null) {
                logger.debug("Initiating WebSocket close");
                this.closeFuture = new CompletableFuture();
                this.webSocket.sendClose(1000, "Closing connection");
                try {
                    this.closeFuture.join();
                    logger.debug("WebSocket close completed normally");
                }
                catch (Exception e) {
                    logger.error("Error during WebSocket close", (Throwable)e);
                    if (this.errorCallback == null) break block3;
                    this.errorCallback.accept(e);
                }
            }
        }
    }
}

