/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient;

import io.github.sashirestela.cleverclient.http.HttpProcessor;
import io.github.sashirestela.cleverclient.support.CleverClientSSE;
import java.net.http.HttpClient;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleverClient {
    private static Logger logger = LoggerFactory.getLogger(CleverClient.class);
    @NonNull
    private String urlBase;
    private List<String> headers;
    private HttpClient httpClient;
    private HttpProcessor httpProcessor;

    public CleverClient(String urlBase, List<String> headers, HttpClient httpClient, String endOfStream) {
        this.urlBase = urlBase;
        this.headers = Optional.ofNullable(headers).orElse(List.of());
        this.httpClient = Optional.ofNullable(httpClient).orElse(HttpClient.newHttpClient());
        this.httpProcessor = new HttpProcessor(this.httpClient, this.urlBase, this.headers);
        CleverClientSSE.setEndOfStream(endOfStream);
        logger.debug("CleverClient has been created.");
    }

    public <T> T create(Class<T> interfaceClass) {
        return this.httpProcessor.createProxy(interfaceClass);
    }

    public static CleverClientBuilder builder() {
        return new CleverClientBuilder();
    }

    @NonNull
    public String getUrlBase() {
        return this.urlBase;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpProcessor getHttpProcessor() {
        return this.httpProcessor;
    }

    public static class CleverClientBuilder {
        private String urlBase;
        private List<String> headers;
        private HttpClient httpClient;
        private String endOfStream;

        CleverClientBuilder() {
        }

        public CleverClientBuilder urlBase(String urlBase) {
            this.urlBase = urlBase;
            return this;
        }

        public CleverClientBuilder headers(List<String> headers) {
            this.headers = headers;
            return this;
        }

        public CleverClientBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public CleverClientBuilder endOfStream(String endOfStream) {
            this.endOfStream = endOfStream;
            return this;
        }

        public CleverClient build() {
            return new CleverClient(this.urlBase, this.headers, this.httpClient, this.endOfStream);
        }

        public String toString() {
            return "CleverClient.CleverClientBuilder(urlBase=" + this.urlBase + ", headers=" + this.headers + ", httpClient=" + this.httpClient + ", endOfStream=" + this.endOfStream + ")";
        }
    }
}

