/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.sashirestela.cleverclient.support.CleverClientException;
import io.github.sashirestela.cleverclient.util.CommonUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

public class ReflectUtil {
    private ReflectUtil() {
    }

    public static <T> T createProxy(Class<T> interfaceClass, InvocationHandler handler) {
        return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, handler);
    }

    public static Map<String, Object> getMapFields(Object object) {
        Field[] fields;
        String GET_PREFIX = "get";
        HashMap<String, Object> structure = new HashMap<String, Object>();
        Class<?> clazz = object.getClass();
        for (Field field : fields = ReflectUtil.getFields(clazz)) {
            Object fieldValue;
            String fieldName = field.getName();
            String methodName = "get" + CommonUtil.capitalize(fieldName);
            try {
                Method getMethod = clazz.getMethod(methodName, new Class[0]);
                fieldValue = getMethod.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                throw new CleverClientException("Cannot find the method {0} in the class {1}.", methodName, clazz.getSimpleName(), e);
            }
            if (fieldValue == null) continue;
            structure.put(ReflectUtil.getFieldName(field), ReflectUtil.getFieldValue(fieldValue));
        }
        return structure;
    }

    private static Field[] getFields(Class<?> clazz) {
        String CLASS_OBJECT = "Object";
        Field[] fields = new Field[]{};
        Class<?> nextClazz = clazz;
        while (!nextClazz.getSimpleName().equals("Object")) {
            fields = CommonUtil.concatArrays(fields, nextClazz.getDeclaredFields());
            nextClazz = nextClazz.getSuperclass();
        }
        return fields;
    }

    private static String getFieldName(Field field) {
        String JSON_PROPERTY_METHOD_NAME = "value";
        String fieldName = field.getName();
        if (field.isAnnotationPresent(JsonProperty.class)) {
            fieldName = (String)ReflectUtil.getAnnotAttribValue(field, JsonProperty.class, "value");
        }
        return fieldName;
    }

    private static Object getFieldValue(Object fieldValue) {
        if (fieldValue.getClass().isEnum()) {
            String enumConstantName = ((Enum)fieldValue).name();
            try {
                fieldValue = fieldValue.getClass().getField(enumConstantName).getAnnotation(JsonProperty.class).value();
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new CleverClientException("Cannot find the enum constant {0}.", enumConstantName, e);
            }
        }
        return fieldValue;
    }

    private static Object getAnnotAttribValue(AnnotatedElement element, Class<? extends Annotation> annotType, String annotAttribName) {
        Object value = null;
        Annotation annotation = element.getAnnotation(annotType);
        if (annotation != null) {
            Method annotAttrib = null;
            try {
                annotAttrib = annotType.getMethod(annotAttribName, new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new CleverClientException("Cannot find the method {0} in the annotation {1}.", annotAttribName, annotType.getName(), e);
            }
            try {
                value = annotAttrib.invoke((Object)annotation, (Object[])null);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new CleverClientException("Cannot execute the method {0} in the annotation {1}.", annotAttribName, annotType.getName(), e);
            }
        }
        return value;
    }
}

