/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.ui.detail;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageButton;
import android.widget.Toast;
import androidx.core.content.ContextCompat;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.google.android.material.snackbar.Snackbar;
import com.sangcomz.fishbun.BaseActivity;
import com.sangcomz.fishbun.R;
import com.sangcomz.fishbun.adapter.view.DetailViewPagerAdapter;
import com.sangcomz.fishbun.define.Define;
import com.sangcomz.fishbun.ui.detail.DetailController;
import com.sangcomz.fishbun.util.RadioWithTextButton;
import com.sangcomz.fishbun.util.UiUtil;

public class DetailActivity
extends BaseActivity
implements View.OnClickListener,
ViewPager.OnPageChangeListener {
    private static final String TAG = "DetailActivity";
    private DetailController controller;
    private int initPosition;
    private RadioWithTextButton btnDetailCount;
    private ViewPager vpDetailPager;
    private ImageButton btnDetailBack;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().requestFeature(12);
        }
        this.setContentView(R.layout.activity_detail_actiivy);
        this.initController();
        this.initValue();
        this.initView();
        this.initAdapter();
        this.initToolBar();
    }

    private void initController() {
        this.controller = new DetailController(this);
    }

    private void initView() {
        this.btnDetailCount = (RadioWithTextButton)this.findViewById(R.id.btn_detail_count);
        this.vpDetailPager = (ViewPager)this.findViewById(R.id.vp_detail_pager);
        this.btnDetailBack = (ImageButton)this.findViewById(R.id.btn_detail_back);
        this.btnDetailCount.unselect();
        this.btnDetailCount.setCircleColor(this.fishton.getColorActionBar());
        this.btnDetailCount.setTextColor(this.fishton.getColorActionBarTitle());
        this.btnDetailCount.setStrokeColor(this.fishton.getColorSelectCircleStroke());
        this.btnDetailCount.setOnClickListener(this);
        this.btnDetailBack.setOnClickListener((View.OnClickListener)this);
        this.initToolBar();
    }

    private void initValue() {
        Intent intent = this.getIntent();
        this.initPosition = intent.getIntExtra(Define.BUNDLE_NAME.POSITION.name(), -1);
    }

    private void initToolBar() {
        if (Build.VERSION.SDK_INT >= 21) {
            UiUtil.setStatusBarColor((Activity)this, this.fishton.getColorStatusBar());
        }
        if (this.fishton.isStatusBarLight() && Build.VERSION.SDK_INT >= 23) {
            this.vpDetailPager.setSystemUiVisibility(8192);
        }
    }

    private void initAdapter() {
        if (this.fishton.getPickerImages() == null) {
            Toast.makeText((Context)this, (int)R.string.msg_error, (int)0).show();
            this.finish();
            return;
        }
        this.onCheckStateChange(this.fishton.getPickerImages().get(this.initPosition));
        DetailViewPagerAdapter adapter = new DetailViewPagerAdapter(this.getLayoutInflater(), this.fishton.getPickerImages());
        this.vpDetailPager.setAdapter((PagerAdapter)adapter);
        this.vpDetailPager.setCurrentItem(this.initPosition);
        this.vpDetailPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
    }

    public void onCheckStateChange(Uri image) {
        boolean isContained = this.fishton.getSelectedImages().contains(image);
        if (isContained) {
            this.updateRadioButton(this.btnDetailCount, String.valueOf(this.fishton.getSelectedImages().indexOf(image) + 1));
        } else {
            this.btnDetailCount.unselect();
        }
    }

    public void updateRadioButton(RadioWithTextButton v, String text) {
        if (this.fishton.getMaxCount() == 1) {
            v.setDrawable(ContextCompat.getDrawable((Context)v.getContext(), (int)R.drawable.ic_done_white_24dp));
        } else {
            v.setText(text);
        }
    }

    public void onBackPressed() {
        this.finishActivity();
    }

    public void onClick(View v) {
        if (this.fishton.getPickerImages() == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.btn_detail_count) {
            Uri image = this.fishton.getPickerImages().get(this.vpDetailPager.getCurrentItem());
            if (this.fishton.getSelectedImages().contains(image)) {
                this.fishton.getSelectedImages().remove(image);
                this.onCheckStateChange(image);
            } else if (this.fishton.getSelectedImages().size() == this.fishton.getMaxCount()) {
                Snackbar.make((View)v, (CharSequence)this.fishton.getMessageLimitReached(), (int)-1).show();
            } else {
                this.fishton.getSelectedImages().add(image);
                this.onCheckStateChange(image);
                if (this.fishton.isAutomaticClose() && this.fishton.getSelectedImages().size() == this.fishton.getMaxCount()) {
                    this.finishActivity();
                }
            }
        } else if (id2 == R.id.btn_detail_back) {
            this.finishActivity();
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        if (this.fishton.getPickerImages() != null) {
            this.onCheckStateChange(this.fishton.getPickerImages().get(position));
        }
    }

    public void onPageScrollStateChanged(int state) {
    }

    void finishActivity() {
        Intent i = new Intent();
        this.setResult(-1, i);
        this.finish();
    }
}

