/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.ui.album;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import com.sangcomz.fishbun.MimeType;
import com.sangcomz.fishbun.bean.Album;
import com.sangcomz.fishbun.ext.MimeTypeExt;
import com.sangcomz.fishbun.permission.PermissionCheck;
import com.sangcomz.fishbun.ui.album.AlbumActivity;
import com.sangcomz.fishbun.util.CameraUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class AlbumController {
    private AlbumActivity albumActivity;
    private ContentResolver resolver;
    private CameraUtil cameraUtil = new CameraUtil();

    AlbumController(AlbumActivity albumActivity) {
        this.albumActivity = albumActivity;
        this.resolver = albumActivity.getContentResolver();
    }

    boolean checkPermission() {
        PermissionCheck permissionCheck = new PermissionCheck((Context)this.albumActivity);
        if (Build.VERSION.SDK_INT >= 23) {
            return permissionCheck.CheckStoragePermission();
        }
        return true;
    }

    boolean checkCameraPermission() {
        PermissionCheck permissionCheck = new PermissionCheck((Context)this.albumActivity);
        if (Build.VERSION.SDK_INT >= 23) {
            return permissionCheck.CheckCameraPermission();
        }
        return true;
    }

    void getAlbumList(String allViewTitle, List<MimeType> exceptMimeTypeList, List<String> specifyFolderList) {
        new LoadAlbumList(allViewTitle, exceptMimeTypeList, specifyFolderList).execute(new Void[0]);
    }

    void takePicture(Activity activity, String saveDir) {
        this.cameraUtil.takePicture(activity, saveDir);
    }

    String getSavePath() {
        return this.cameraUtil.getSavePath();
    }

    String getPathDir() {
        return Environment.getExternalStoragePublicDirectory((String)(Environment.DIRECTORY_DCIM + "/Camera")).getAbsolutePath();
    }

    private boolean isExceptMemeType(List<MimeType> mimeTypes, String mimeType) {
        for (MimeType type : mimeTypes) {
            if (!MimeTypeExt.equalsMimeType(type, mimeType)) continue;
            return true;
        }
        return false;
    }

    private boolean isNotContainsSpecifyFolderList(List<String> specifyFolderList, String displayBundleName) {
        if (specifyFolderList.isEmpty()) {
            return false;
        }
        return !specifyFolderList.contains(displayBundleName);
    }

    private class LoadAlbumList
    extends AsyncTask<Void, Void, List<Album>> {
        String allViewTitle;
        List<MimeType> exceptMimeTypeList;
        List<String> specifyFolderList;

        LoadAlbumList(String allViewTitle, List<MimeType> exceptMimeTypeList, List<String> specifyFolderList) {
            this.allViewTitle = allViewTitle;
            this.exceptMimeTypeList = exceptMimeTypeList;
            this.specifyFolderList = specifyFolderList;
        }

        protected List<Album> doInBackground(Void ... params) {
            HashMap<Long, Album> albumHashMap = new HashMap<Long, Album>();
            String orderBy = "_id DESC";
            String[] projection = new String[]{"_id", "bucket_display_name", "mime_type", "bucket_id"};
            Cursor c = AlbumController.this.resolver.query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, projection, null, null, "_id DESC");
            int totalCounter = 0;
            if (c != null) {
                int bucketMimeType = c.getColumnIndex("mime_type");
                int bucketColumn = c.getColumnIndex("bucket_display_name");
                int bucketColumnId = c.getColumnIndex("bucket_id");
                if (!AlbumController.this.isNotContainsSpecifyFolderList(this.specifyFolderList, this.allViewTitle)) {
                    albumHashMap.put(0L, new Album(0L, this.allViewTitle, null, 0));
                }
                while (c.moveToNext()) {
                    String mimeType = c.getString(bucketMimeType);
                    String folderName = c.getString(bucketColumn);
                    if (AlbumController.this.isExceptMemeType(this.exceptMimeTypeList, mimeType) || AlbumController.this.isNotContainsSpecifyFolderList(this.specifyFolderList, folderName)) continue;
                    ++totalCounter;
                    long bucketId = c.getInt(bucketColumnId);
                    Album album = (Album)albumHashMap.get(bucketId);
                    if (album == null) {
                        int imgId = c.getInt(c.getColumnIndex("_id"));
                        Uri path = Uri.withAppendedPath((Uri)MediaStore.Images.Media.EXTERNAL_CONTENT_URI, (String)("" + imgId));
                        albumHashMap.put(bucketId, new Album(bucketId, folderName, path.toString(), 1));
                        if (albumHashMap.get(0L) == null || ((Album)albumHashMap.get((Object)Long.valueOf((long)0L))).thumbnailPath != null) continue;
                        ((Album)albumHashMap.get((Object)Long.valueOf((long)0L))).thumbnailPath = path.toString();
                        continue;
                    }
                    ++album.counter;
                }
                Album allAlbum = (Album)albumHashMap.get(0L);
                if (allAlbum != null) {
                    allAlbum.counter = totalCounter;
                }
                c.close();
            }
            if (totalCounter == 0) {
                albumHashMap.clear();
            }
            ArrayList<Album> albumList = new ArrayList<Album>();
            for (Album album : albumHashMap.values()) {
                if (album.bucketId == 0L) {
                    albumList.add(0, album);
                    continue;
                }
                albumList.add(album);
            }
            return albumList;
        }

        protected void onPostExecute(List<Album> albumList) {
            super.onPostExecute(albumList);
            AlbumController.this.albumActivity.setAlbumList(albumList);
        }
    }
}

