/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.ui.album;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.Toolbar;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.snackbar.Snackbar;
import com.sangcomz.fishbun.BaseActivity;
import com.sangcomz.fishbun.R;
import com.sangcomz.fishbun.adapter.view.AlbumListAdapter;
import com.sangcomz.fishbun.bean.Album;
import com.sangcomz.fishbun.permission.PermissionCheck;
import com.sangcomz.fishbun.ui.album.AlbumController;
import com.sangcomz.fishbun.util.SingleMediaScanner;
import com.sangcomz.fishbun.util.UiUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;

public class AlbumActivity
extends BaseActivity {
    private AlbumController albumController;
    private List<Album> albumList = Collections.emptyList();
    private RecyclerView recyclerAlbumList;
    private RelativeLayout relAlbumEmpty;
    private AlbumListAdapter adapter;
    private TextView progressAlbumText;

    protected void onSaveInstanceState(Bundle outState) {
        if (this.adapter != null) {
            outState.putParcelableArrayList(this.define.SAVE_INSTANCE_ALBUM_LIST, (ArrayList)this.adapter.getAlbumList());
        }
        super.onSaveInstanceState(outState);
    }

    protected void onRestoreInstanceState(Bundle outState) {
        super.onRestoreInstanceState(outState);
        ArrayList albumList = outState.getParcelableArrayList(this.define.SAVE_INSTANCE_ALBUM_LIST);
        ArrayList thumbList = outState.getParcelableArrayList(this.define.SAVE_INSTANCE_ALBUM_THUMB_LIST);
        if (albumList != null && thumbList != null && this.fishton.getSelectedImages() != null) {
            this.adapter = new AlbumListAdapter();
            this.adapter.setAlbumList(albumList);
        }
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_photo_album);
        this.initView();
        this.initController();
        if (this.albumController.checkPermission()) {
            this.albumController.getAlbumList(this.fishton.getTitleAlbumAllView(), this.fishton.getExceptMimeTypeList(), this.fishton.getSpecifyFolderList());
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.recyclerAlbumList != null && this.recyclerAlbumList.getLayoutManager() != null) {
            if (UiUtil.isLandscape((Context)this)) {
                ((GridLayoutManager)this.recyclerAlbumList.getLayoutManager()).setSpanCount(this.fishton.getAlbumLandscapeSpanCount());
            } else {
                ((GridLayoutManager)this.recyclerAlbumList.getLayoutManager()).setSpanCount(this.fishton.getAlbumPortraitSpanCount());
            }
        }
    }

    private void initView() {
        LinearLayout linearAlbumCamera = (LinearLayout)this.findViewById(R.id.lin_album_camera);
        linearAlbumCamera.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (AlbumActivity.this.albumController.checkCameraPermission()) {
                    AlbumActivity.this.albumController.takePicture((Activity)AlbumActivity.this, AlbumActivity.this.albumController.getPathDir());
                }
            }
        });
        this.initToolBar();
    }

    private void initRecyclerView() {
        this.recyclerAlbumList = (RecyclerView)this.findViewById(R.id.recycler_album_list);
        GridLayoutManager layoutManager = UiUtil.isLandscape((Context)this) ? new GridLayoutManager((Context)this, this.fishton.getAlbumLandscapeSpanCount()) : new GridLayoutManager((Context)this, this.fishton.getAlbumPortraitSpanCount());
        if (this.recyclerAlbumList != null) {
            this.recyclerAlbumList.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        }
    }

    private void initToolBar() {
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar_album_bar);
        this.relAlbumEmpty = (RelativeLayout)this.findViewById(R.id.rel_album_empty);
        this.progressAlbumText = (TextView)this.findViewById(R.id.txt_album_msg);
        this.progressAlbumText.setText(R.string.msg_loading_image);
        this.setSupportActionBar(toolbar);
        toolbar.setBackgroundColor(this.fishton.getColorActionBar());
        toolbar.setTitleTextColor(this.fishton.getColorActionBarTitle());
        if (Build.VERSION.SDK_INT >= 21) {
            UiUtil.setStatusBarColor((Activity)this, this.fishton.getColorStatusBar());
        }
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setTitle((CharSequence)this.fishton.getTitleActionBar());
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            if (this.fishton.getDrawableHomeAsUpIndicator() != null) {
                this.getSupportActionBar().setHomeAsUpIndicator(this.fishton.getDrawableHomeAsUpIndicator());
            }
        }
        if (this.fishton.isStatusBarLight() && Build.VERSION.SDK_INT >= 23) {
            toolbar.setSystemUiVisibility(8192);
        }
    }

    private void initController() {
        this.albumController = new AlbumController(this);
    }

    private void setAlbumListAdapter() {
        if (this.adapter == null) {
            this.adapter = new AlbumListAdapter();
        }
        this.adapter.setAlbumList(this.albumList);
        this.recyclerAlbumList.setAdapter((RecyclerView.Adapter)this.adapter);
        this.adapter.notifyDataSetChanged();
        this.changeToolbarTitle();
    }

    protected void setAlbumList(List<Album> albumList) {
        this.albumList = albumList;
        if (albumList.size() > 0) {
            this.relAlbumEmpty.setVisibility(8);
            this.initRecyclerView();
            this.setAlbumListAdapter();
        } else {
            this.relAlbumEmpty.setVisibility(0);
            this.progressAlbumText.setText(R.string.msg_no_image);
        }
    }

    private void refreshList(int position, ArrayList<Uri> imagePath) {
        if (imagePath.size() > 0) {
            if (position == 0) {
                this.albumController.getAlbumList(this.fishton.getTitleAlbumAllView(), this.fishton.getExceptMimeTypeList(), this.fishton.getSpecifyFolderList());
            } else {
                this.albumList.get((int)0).counter += imagePath.size();
                this.albumList.get((int)position).counter += imagePath.size();
                this.albumList.get((int)0).thumbnailPath = imagePath.get(imagePath.size() - 1).toString();
                this.albumList.get((int)position).thumbnailPath = imagePath.get(imagePath.size() - 1).toString();
                this.adapter.notifyItemChanged(0);
                this.adapter.notifyItemChanged(position);
            }
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        if (this.fishton.isButton()) {
            this.getMenuInflater().inflate(R.menu.menu_photo_album, menu2);
            MenuItem menuDoneItem = menu2.findItem(R.id.action_done);
            menu2.findItem(R.id.action_all_done).setVisible(false);
            if (this.fishton.getDrawableDoneButton() != null) {
                menuDoneItem.setIcon(this.fishton.getDrawableDoneButton());
            } else if (this.fishton.getStrDoneMenu() != null) {
                if (this.fishton.getColorTextMenu() != Integer.MAX_VALUE) {
                    SpannableString spanString = new SpannableString((CharSequence)this.fishton.getStrDoneMenu());
                    spanString.setSpan((Object)new ForegroundColorSpan(this.fishton.getColorTextMenu()), 0, spanString.length(), 0);
                    menuDoneItem.setTitle((CharSequence)spanString);
                } else {
                    menuDoneItem.setTitle((CharSequence)this.fishton.getStrDoneMenu());
                }
                menuDoneItem.setIcon(null);
            }
        }
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 16908332) {
            this.finish();
        } else if (id2 == R.id.action_done && this.adapter != null) {
            if (this.fishton.getSelectedImages().size() < this.fishton.getMinCount()) {
                Snackbar.make((View)this.recyclerAlbumList, (CharSequence)this.fishton.getMessageNothingSelected(), (int)-1).show();
            } else {
                this.finishActivity();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void changeToolbarTitle() {
        if (this.adapter == null) {
            return;
        }
        int total = this.fishton.getSelectedImages().size();
        if (this.getSupportActionBar() != null) {
            if (this.fishton.getMaxCount() == 1 || !this.fishton.isShowCount()) {
                this.getSupportActionBar().setTitle((CharSequence)this.fishton.getTitleActionBar());
            } else {
                this.getSupportActionBar().setTitle((CharSequence)(this.fishton.getTitleActionBar() + " (" + total + "/" + this.fishton.getMaxCount() + ")"));
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == this.define.ENTER_ALBUM_REQUEST_CODE) {
            if (resultCode == -1) {
                this.finishActivity();
            } else {
                this.define.getClass();
                if (resultCode == 29) {
                    ArrayList addPath = data.getParcelableArrayListExtra(this.define.INTENT_ADD_PATH);
                    int position = data.getIntExtra(this.define.INTENT_POSITION, -1);
                    this.refreshList(position, addPath);
                    this.changeToolbarTitle();
                }
            }
        } else if (requestCode == this.define.TAKE_A_PICK_REQUEST_CODE) {
            if (resultCode == -1) {
                new SingleMediaScanner((Context)this, new File(this.albumController.getSavePath()), new Function0<Unit>(){

                    public Unit invoke() {
                        AlbumActivity.this.albumController.getAlbumList(AlbumActivity.this.fishton.getTitleAlbumAllView(), AlbumActivity.this.fishton.getExceptMimeTypeList(), AlbumActivity.this.fishton.getSpecifyFolderList());
                        return Unit.INSTANCE;
                    }
                });
            } else {
                new File(this.albumController.getSavePath()).delete();
            }
            this.changeToolbarTitle();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        switch (requestCode) {
            case 28: {
                if (grantResults.length <= 0) break;
                if (grantResults[0] == 0) {
                    this.albumController.getAlbumList(this.fishton.getTitleAlbumAllView(), this.fishton.getExceptMimeTypeList(), this.fishton.getSpecifyFolderList());
                    break;
                }
                new PermissionCheck((Context)this).showPermissionDialog();
                this.finish();
                break;
            }
            case 29: {
                if (grantResults.length <= 0) break;
                if (grantResults[0] == 0) {
                    this.albumController.takePicture((Activity)this, this.albumController.getPathDir());
                    break;
                }
                new PermissionCheck((Context)this).showPermissionDialog();
            }
        }
    }

    private void finishActivity() {
        Intent i = new Intent();
        i.putParcelableArrayListExtra("intent_path", this.fishton.getSelectedImages());
        this.setResult(-1, i);
        this.finish();
    }
}

