/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.adapter.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.snackbar.Snackbar;
import com.sangcomz.fishbun.Fishton;
import com.sangcomz.fishbun.R;
import com.sangcomz.fishbun.define.Define;
import com.sangcomz.fishbun.ui.detail.DetailActivity;
import com.sangcomz.fishbun.ui.picker.PickerActivity;
import com.sangcomz.fishbun.ui.picker.PickerController;
import com.sangcomz.fishbun.util.RadioWithTextButton;
import java.util.ArrayList;

public class PickerGridAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int TYPE_HEADER = Integer.MIN_VALUE;
    private Fishton fishton;
    private PickerController pickerController;
    private OnPhotoActionListener actionListener;
    private String saveDir;

    public PickerGridAdapter(PickerController pickerController, String saveDir) {
        this.pickerController = pickerController;
        this.saveDir = saveDir;
        this.fishton = Fishton.getInstance();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == Integer.MIN_VALUE) {
            View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.header_item, parent, false);
            return new ViewHolderHeader(view);
        }
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.thumb_item, parent, false);
        return new ViewHolderImage(view);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof ViewHolderHeader) {
            final ViewHolderHeader vh = (ViewHolderHeader)holder;
            vh.header.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (PickerGridAdapter.this.pickerController.checkCameraPermission()) {
                        PickerGridAdapter.this.pickerController.takePicture((Activity)vh.header.getContext(), PickerGridAdapter.this.saveDir);
                    }
                }
            });
        }
        if (holder instanceof ViewHolderImage) {
            final int imagePos = this.fishton.isCamera() ? position - 1 : position;
            final ViewHolderImage vh = (ViewHolderImage)holder;
            final Uri image = this.fishton.getPickerImages().get(imagePos);
            final Context context = vh.item.getContext();
            vh.item.setTag((Object)image);
            vh.btnThumbCount.unselect();
            vh.btnThumbCount.setCircleColor(this.fishton.getColorActionBar());
            vh.btnThumbCount.setTextColor(this.fishton.getColorActionBarTitle());
            vh.btnThumbCount.setStrokeColor(this.fishton.getColorSelectCircleStroke());
            this.initState(this.fishton.getSelectedImages().indexOf(image), vh);
            if (image != null && vh.imgThumbImage != null) {
                Fishton.getInstance().getImageAdapter().loadImage(vh.imgThumbImage, image);
            }
            vh.btnThumbCount.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PickerGridAdapter.this.onCheckStateChange(vh.item, image);
                }
            });
            vh.imgThumbImage.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (PickerGridAdapter.this.fishton.isUseDetailView()) {
                        if (context instanceof PickerActivity) {
                            PickerActivity activity = (PickerActivity)context;
                            Intent i = new Intent((Context)activity, DetailActivity.class);
                            i.putExtra(Define.BUNDLE_NAME.POSITION.name(), imagePos);
                            activity.startActivityForResult(i, new Define().ENTER_DETAIL_REQUEST_CODE);
                        }
                    } else {
                        PickerGridAdapter.this.onCheckStateChange(vh.item, image);
                    }
                }
            });
        }
    }

    private void initState(int selectedIndex, ViewHolderImage vh) {
        if (selectedIndex != -1) {
            this.animScale((View)vh.imgThumbImage, true, false);
            this.updateRadioButton(vh.btnThumbCount, String.valueOf(selectedIndex + 1));
        } else {
            this.animScale((View)vh.imgThumbImage, false, false);
        }
    }

    private void onCheckStateChange(View v, Uri image) {
        ArrayList<Uri> pickedImages = this.fishton.getSelectedImages();
        boolean isContained = pickedImages.contains(image);
        if (this.fishton.getMaxCount() == pickedImages.size() && !isContained) {
            Snackbar.make((View)v, (CharSequence)this.fishton.getMessageLimitReached(), (int)-1).show();
            return;
        }
        ImageView imgThumbImage = (ImageView)v.findViewById(R.id.img_thumb_image);
        RadioWithTextButton btnThumbCount = (RadioWithTextButton)v.findViewById(R.id.btn_thumb_count);
        if (isContained) {
            pickedImages.remove(image);
            btnThumbCount.unselect();
            this.animScale((View)imgThumbImage, false, true);
        } else {
            this.animScale((View)imgThumbImage, true, true);
            pickedImages.add(image);
            if (this.fishton.isAutomaticClose() && this.fishton.getMaxCount() == pickedImages.size()) {
                this.pickerController.finishActivity();
            }
            this.updateRadioButton(btnThumbCount, String.valueOf(pickedImages.size()));
        }
        this.pickerController.setToolbarTitle(pickedImages.size());
    }

    public void updateRadioButton(RadioWithTextButton v, String text) {
        if (this.fishton.getMaxCount() == 1) {
            v.setDrawable(ContextCompat.getDrawable((Context)v.getContext(), (int)R.drawable.ic_done_white_24dp));
        } else {
            v.setText(text);
        }
    }

    public void updateRadioButton(ImageView imageView, RadioWithTextButton v, String text, boolean isSelected) {
        if (isSelected) {
            this.animScale((View)imageView, isSelected, false);
            if (this.fishton.getMaxCount() == 1) {
                v.setDrawable(ContextCompat.getDrawable((Context)v.getContext(), (int)R.drawable.ic_done_white_24dp));
            } else {
                v.setText(text);
            }
        } else {
            v.unselect();
        }
    }

    private void animScale(View view, final boolean isSelected, final boolean isAnimation) {
        int duration = 200;
        if (!isAnimation) {
            duration = 0;
        }
        float toScale = isSelected ? 0.8f : 1.0f;
        ViewCompat.animate((View)view).setDuration((long)duration).withStartAction(new Runnable(){

            @Override
            public void run() {
            }
        }).scaleX(toScale).scaleY(toScale).withEndAction(new Runnable(){

            @Override
            public void run() {
                if (isAnimation && !isSelected) {
                    PickerGridAdapter.this.actionListener.onDeselect();
                }
            }
        }).start();
    }

    public int getItemCount() {
        int count = this.fishton.getPickerImages() == null ? 0 : this.fishton.getPickerImages().size();
        if (this.fishton.isCamera()) {
            return count + 1;
        }
        if (this.fishton.getPickerImages() == null) {
            return 0;
        }
        return count;
    }

    public int getItemViewType(int position) {
        if (position == 0 && this.fishton.isCamera()) {
            return Integer.MIN_VALUE;
        }
        return super.getItemViewType(position);
    }

    public void addImage(Uri path) {
        ArrayList<Uri> al = new ArrayList<Uri>();
        if (this.fishton.getPickerImages() != null) {
            al.addAll(this.fishton.getPickerImages());
        }
        al.add(0, path);
        this.fishton.setPickerImages(al);
        this.notifyDataSetChanged();
        this.pickerController.setAddImagePath(path);
    }

    public void setActionListener(OnPhotoActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public class ViewHolderHeader
    extends RecyclerView.ViewHolder {
        RelativeLayout header;

        public ViewHolderHeader(View view) {
            super(view);
            this.header = (RelativeLayout)this.itemView.findViewById(R.id.rel_header_area);
        }
    }

    public class ViewHolderImage
    extends RecyclerView.ViewHolder {
        View item;
        ImageView imgThumbImage;
        RadioWithTextButton btnThumbCount;

        public ViewHolderImage(View view) {
            super(view);
            this.item = view;
            this.imgThumbImage = (ImageView)view.findViewById(R.id.img_thumb_image);
            this.btnThumbCount = (RadioWithTextButton)view.findViewById(R.id.btn_thumb_count);
        }
    }

    public static interface OnPhotoActionListener {
        public void onDeselect();
    }
}

