/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.swagger2markup;

import io.github.robwin.markup.builder.MarkupLanguage;
import io.github.robwin.swagger2markup.GroupBy;
import io.github.robwin.swagger2markup.Language;
import io.github.robwin.swagger2markup.OrderBy;
import io.github.robwin.swagger2markup.Swagger2MarkupConverter;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="process-swagger")
public class Swagger2MarkupMojo
extends AbstractMojo {
    private static final String PREFIX = "swagger2markup.";
    @Parameter(property="swagger2markup.inputDirectory", defaultValue="${project.basedir}/src/docs/swagger", required=true)
    protected String inputDirectory;
    @Parameter(property="swagger2markup.outputDirectory", required=true)
    protected File outputDirectory;
    @Parameter(property="swagger2markup.markupLanguage", defaultValue="asciidoc", required=true)
    protected String markupLanguage = "asciidoc";
    @Parameter(property="swagger2markup.pathsGroupedBy", required=false)
    protected String pathsGroupedBy;
    @Parameter(property="swagger2markup.definitionsOrderedBy", required=false)
    protected String definitionsOrderedBy;
    @Parameter(property="swagger2markup.examplesDirectory", required=false)
    protected File examplesDirectory;
    @Parameter(property="swagger2markup.descriptionsDirectory", required=false)
    protected File descriptionsDirectory;
    @Parameter(property="swagger2markup.schemasDirectory", required=false)
    protected File schemasDirectory;
    @Parameter(property="swagger2markup.separateDefinitions", required=false)
    protected Boolean separateDefinitions;
    @Parameter(defaultValue="${project.build.directory}")
    protected String projectBuildDir;
    @Parameter(defaultValue="EN")
    protected Language outputLanguage;
    @Parameter(property="swagger2markup.swaggerFile", required=false)
    protected String swaggerFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"convertSwagger2markup task started");
            this.getLog().debug((CharSequence)("InputDir: " + this.inputDirectory));
            this.getLog().debug((CharSequence)("OutputDir: " + this.outputDirectory));
            this.getLog().debug((CharSequence)("PathsGroupedBy: " + this.pathsGroupedBy));
            this.getLog().debug((CharSequence)("DefinitionsOrderedBy: " + this.definitionsOrderedBy));
            this.getLog().debug((CharSequence)("ExamplesDir: " + this.examplesDirectory));
            this.getLog().debug((CharSequence)("DescriptionsDir: " + this.descriptionsDirectory));
            this.getLog().debug((CharSequence)("SchemasDir: " + this.schemasDirectory));
            this.getLog().debug((CharSequence)("MarkupLanguage: " + this.markupLanguage));
            this.getLog().debug((CharSequence)("SeparateDefinitions: " + this.separateDefinitions));
            this.getLog().debug((CharSequence)("OutputLanguage: " + this.outputLanguage));
            this.getLog().debug((CharSequence)("SwaggerFile: " + this.swaggerFile));
        }
        MarkupLanguage markupLanguageEnum = MarkupLanguage.valueOf((String)this.markupLanguage.toUpperCase());
        if (this.outputDirectory == null) {
            this.outputDirectory = new File(this.projectBuildDir, this.markupLanguage.toLowerCase());
        }
        if (this.inputDirectory.startsWith("http")) {
            this.convertFileOrUrl(markupLanguageEnum, this.inputDirectory);
        } else if (StringUtils.isEmpty((CharSequence)this.swaggerFile)) {
            File[] files = new File(this.inputDirectory).getAbsoluteFile().listFiles();
            if (files == null || files.length == 0) {
                throw new MojoFailureException("No swagger files found in directory: " + this.inputDirectory);
            }
            for (File file : files) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("File: " + file.getAbsolutePath()));
                }
                this.convertFileOrUrl(markupLanguageEnum, file.getAbsolutePath());
            }
        } else {
            File file = new File(this.inputDirectory, this.swaggerFile).getAbsoluteFile();
            if (!file.exists()) {
                throw new MojoFailureException("Can't find swagger file '" + file.getAbsolutePath() + "'");
            }
            this.convertFileOrUrl(markupLanguageEnum, file.getAbsolutePath());
        }
        this.getLog().debug((CharSequence)"convertSwagger2markup task finished");
    }

    private void convertFileOrUrl(MarkupLanguage markupLanguageEnum, String source) throws MojoFailureException {
        Swagger2MarkupConverter.Builder builder = Swagger2MarkupConverter.from((String)source).withMarkupLanguage(markupLanguageEnum);
        if (this.pathsGroupedBy != null) {
            builder.withPathsGroupedBy(GroupBy.valueOf((String)this.pathsGroupedBy.toUpperCase()));
        }
        if (this.definitionsOrderedBy != null) {
            builder.withDefinitionsOrderedBy(OrderBy.valueOf((String)this.definitionsOrderedBy.toUpperCase()));
        }
        if (this.examplesDirectory != null) {
            this.getLog().debug((CharSequence)"Include examples is enabled.");
            builder.withExamples(this.examplesDirectory.getAbsolutePath());
        }
        if (this.descriptionsDirectory != null) {
            this.getLog().debug((CharSequence)"Include descriptions is enabled.");
            builder.withDescriptions(this.descriptionsDirectory.getAbsolutePath());
        }
        if (this.schemasDirectory != null) {
            this.getLog().debug((CharSequence)"Include schemas is enabled.");
            builder.withSchemas(this.schemasDirectory.getAbsolutePath());
        }
        if (this.separateDefinitions != null && this.separateDefinitions.booleanValue()) {
            this.getLog().debug((CharSequence)"Separate definitions enabled.");
            builder.withSeparatedDefinitions();
        }
        if (this.outputLanguage != null) {
            builder.withOutputLanguage(this.outputLanguage);
        }
        try {
            builder.build().intoFolder(this.outputDirectory.getAbsolutePath());
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to write markup to directory: " + this.outputDirectory, (Throwable)e);
        }
    }
}

