/*
 * Decompiled with CFR 0.152.
 */
package com.harissk.pdfpreview.thumbnail;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.harissk.pdfium.PdfiumCore;
import com.harissk.pdfium.exception.PageRenderingException;
import com.harissk.pdfium.util.Size;
import com.harissk.pdfpreview.source.DocumentSource;
import com.harissk.pdfpreview.thumbnail.AspectRatio;
import com.harissk.pdfpreview.thumbnail.PDFThumbnailGenerator;
import com.harissk.pdfpreview.thumbnail.ThumbnailCache;
import com.harissk.pdfpreview.thumbnail.ThumbnailConfig;
import java.io.File;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0001H\u0002JJ\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00012\b\b\u0002\u0010\u0013\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0086@\u00a2\u0006\u0002\u0010\u001dJ:\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0015H\u0082@\u00a2\u0006\u0002\u0010!JT\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100#2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00012\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070#2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0086@\u00a2\u0006\u0002\u0010%J\u0006\u0010&\u001a\u00020\u0007J*\u0010'\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00012\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0015H\u0086@\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/harissk/pdfpreview/thumbnail/PDFThumbnailGenerator;", "", "()V", "thumbnailCache", "Lcom/harissk/pdfpreview/thumbnail/ThumbnailCache;", "calculateRenderDimensions", "Lkotlin/Triple;", "", "Landroid/graphics/RectF;", "pageSize", "Lcom/harissk/pdfium/util/Size;", "config", "Lcom/harissk/pdfpreview/thumbnail/ThumbnailConfig;", "clearCache", "", "generatePageThumbnail", "Landroid/graphics/Bitmap;", "pdfiumCore", "Lcom/harissk/pdfium/PdfiumCore;", "pageIndex", "generateSourceIdentifier", "", "source", "generateThumbnail", "context", "Landroid/content/Context;", "password", "useCache", "", "(Landroid/content/Context;Ljava/lang/Object;ILcom/harissk/pdfpreview/thumbnail/ThumbnailConfig;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "generateThumbnailInternal", "documentSource", "Lcom/harissk/pdfpreview/source/DocumentSource;", "(Landroid/content/Context;Lcom/harissk/pdfpreview/source/DocumentSource;ILcom/harissk/pdfpreview/thumbnail/ThumbnailConfig;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "generateThumbnails", "", "pageIndices", "(Landroid/content/Context;Ljava/lang/Object;Ljava/util/List;Lcom/harissk/pdfpreview/thumbnail/ThumbnailConfig;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCacheSize", "getPageCount", "(Landroid/content/Context;Ljava/lang/Object;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pdfpreview_release"})
@SourceDebugExtension(value={"SMAP\nPDFThumbnailGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PDFThumbnailGenerator.kt\ncom/harissk/pdfpreview/thumbnail/PDFThumbnailGenerator\n+ 2 Bitmap.kt\nandroidx/core/graphics/BitmapKt\n*L\n1#1,421:1\n95#2:422\n95#2:423\n*S KotlinDebug\n*F\n+ 1 PDFThumbnailGenerator.kt\ncom/harissk/pdfpreview/thumbnail/PDFThumbnailGenerator\n*L\n261#1:422\n270#1:423\n*E\n"})
public final class PDFThumbnailGenerator {
    @NotNull
    public static final PDFThumbnailGenerator INSTANCE = new PDFThumbnailGenerator();
    @NotNull
    private static final ThumbnailCache thumbnailCache = new ThumbnailCache(0, 1, null);

    private PDFThumbnailGenerator() {
    }

    @Nullable
    public final Object generateThumbnail(@NotNull Context context, @NotNull Object source, int pageIndex, @NotNull ThumbnailConfig config, @Nullable String password, boolean useCache, @NotNull Continuation<? super Bitmap> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Bitmap>, Object>(source, pageIndex, config, useCache, context, password, null){
            Object L$0;
            int label;
            final /* synthetic */ Object $source;
            final /* synthetic */ int $pageIndex;
            final /* synthetic */ ThumbnailConfig $config;
            final /* synthetic */ boolean $useCache;
            final /* synthetic */ Context $context;
            final /* synthetic */ String $password;
            {
                this.$source = $source;
                this.$pageIndex = $pageIndex;
                this.$config = $config;
                this.$useCache = $useCache;
                this.$context = $context;
                this.$password = $password;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        sourceIdentifier = PDFThumbnailGenerator.access$generateSourceIdentifier(PDFThumbnailGenerator.INSTANCE, this.$source);
                        cacheKey = ThumbnailCache.Companion.generateKey(sourceIdentifier, this.$pageIndex, this.$config);
                        if (this.$useCache) {
                            v0 = (Bitmap)PDFThumbnailGenerator.access$getThumbnailCache$p().get(cacheKey);
                            if (v0 != null) {
                                cachedBitmap = v0;
                                $i$a$-let-PDFThumbnailGenerator$generateThumbnail$2$1 = false;
                                if (!cachedBitmap.isRecycled()) {
                                    return cachedBitmap;
                                }
                            }
                        }
                        documentSource = DocumentSource.Companion.toDocumentSource(this.$source);
                        this.L$0 = cacheKey;
                        this.label = 1;
                        v1 = PDFThumbnailGenerator.access$generateThumbnailInternal(PDFThumbnailGenerator.INSTANCE, this.$context, documentSource, this.$pageIndex, this.$config, this.$password, (Continuation)this);
                        ** if (v1 != var8_2) goto lbl22
lbl21:
                        // 1 sources

                        return var8_2;
lbl22:
                        // 1 sources

                        ** GOTO lbl29
                    }
                    case 1: {
                        cacheKey = (String)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl29:
                            // 2 sources

                            if ((thumbnail = (Bitmap)v1) != null && this.$useCache) {
                                PDFThumbnailGenerator.access$getThumbnailCache$p().put(cacheKey, thumbnail);
                            }
                            var2_3 = thumbnail;
                        }
                        catch (Exception var3_5) {
                            var2_3 = null;
                        }
                        return var2_3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Bitmap> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static /* synthetic */ Object generateThumbnail$default(PDFThumbnailGenerator pDFThumbnailGenerator, Context context, Object object, int n, ThumbnailConfig thumbnailConfig, String string, boolean bl, Continuation continuation, int n2, Object object2) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            thumbnailConfig = new ThumbnailConfig(0, 0, null, false, null, 0, 63, null);
        }
        if ((n2 & 0x10) != 0) {
            string = null;
        }
        if ((n2 & 0x20) != 0) {
            bl = true;
        }
        return pDFThumbnailGenerator.generateThumbnail(context, object, n, thumbnailConfig, string, bl, (Continuation<? super Bitmap>)continuation);
    }

    @Nullable
    public final Object generateThumbnails(@NotNull Context context, @NotNull Object source, @NotNull List<Integer> pageIndices, @NotNull ThumbnailConfig config, @Nullable String password, boolean useCache, @NotNull Continuation<? super List<Bitmap>> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends Bitmap>>, Object>(source, context, password, pageIndices, config, useCache, null){
            int label;
            final /* synthetic */ Object $source;
            final /* synthetic */ Context $context;
            final /* synthetic */ String $password;
            final /* synthetic */ List<Integer> $pageIndices;
            final /* synthetic */ ThumbnailConfig $config;
            final /* synthetic */ boolean $useCache;
            {
                this.$source = $source;
                this.$context = $context;
                this.$password = $password;
                this.$pageIndices = $pageIndices;
                this.$config = $config;
                this.$useCache = $useCache;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        List list;
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            DocumentSource documentSource = DocumentSource.Companion.toDocumentSource(this.$source);
                            String sourceIdentifier = PDFThumbnailGenerator.access$generateSourceIdentifier(PDFThumbnailGenerator.INSTANCE, this.$source);
                            List results = new ArrayList<E>();
                            PdfiumCore pdfiumCore = new PdfiumCore();
                            try {
                                documentSource.createDocument(this.$context, pdfiumCore, this.$password);
                                Iterator<Integer> iterator = this.$pageIndices.iterator();
                                while (iterator.hasNext()) {
                                    Bitmap cachedBitmap;
                                    int pageIndex = ((Number)iterator.next()).intValue();
                                    String cacheKey = ThumbnailCache.Companion.generateKey(sourceIdentifier, pageIndex, this.$config);
                                    Bitmap bitmap = cachedBitmap = this.$useCache ? (Bitmap)PDFThumbnailGenerator.access$getThumbnailCache$p().get(cacheKey) : null;
                                    if (cachedBitmap != null && !cachedBitmap.isRecycled()) {
                                        results.add(cachedBitmap);
                                        continue;
                                    }
                                    Bitmap thumbnail = PDFThumbnailGenerator.access$generatePageThumbnail(PDFThumbnailGenerator.INSTANCE, pdfiumCore, pageIndex, this.$config);
                                    results.add(thumbnail);
                                    if (thumbnail == null || !this.$useCache) continue;
                                    PDFThumbnailGenerator.access$getThumbnailCache$p().put(cacheKey, thumbnail);
                                }
                            }
                            finally {
                                try {
                                    pdfiumCore.close();
                                }
                                catch (Exception exception) {}
                            }
                            list = results;
                        }
                        catch (Exception exception) {
                            void $this$mapTo$iv$iv;
                            Iterable $this$map$iv = this.$pageIndices;
                            boolean $i$f$map = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                ((Number)item$iv$iv).intValue();
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(null);
                            }
                            list = (List)destination$iv$iv;
                        }
                        return list;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<Bitmap>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static /* synthetic */ Object generateThumbnails$default(PDFThumbnailGenerator pDFThumbnailGenerator, Context context, Object object, List list, ThumbnailConfig thumbnailConfig, String string, boolean bl, Continuation continuation, int n, Object object2) {
        if ((n & 8) != 0) {
            thumbnailConfig = new ThumbnailConfig(0, 0, null, false, null, 0, 63, null);
        }
        if ((n & 0x10) != 0) {
            string = null;
        }
        if ((n & 0x20) != 0) {
            bl = true;
        }
        return pDFThumbnailGenerator.generateThumbnails(context, object, list, thumbnailConfig, string, bl, (Continuation<? super List<Bitmap>>)continuation);
    }

    @Nullable
    public final Object getPageCount(@NotNull Context context, @NotNull Object source, @Nullable String password, @NotNull Continuation<? super Integer> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Integer>, Object>(source, context, password, null){
            int label;
            final /* synthetic */ Object $source;
            final /* synthetic */ Context $context;
            final /* synthetic */ String $password;
            {
                this.$source = $source;
                this.$context = $context;
                this.$password = $password;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        int n;
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            int n2;
                            DocumentSource documentSource = DocumentSource.Companion.toDocumentSource(this.$source);
                            PdfiumCore pdfiumCore = new PdfiumCore();
                            try {
                                documentSource.createDocument(this.$context, pdfiumCore, this.$password);
                                n2 = pdfiumCore.getPageCount();
                            }
                            finally {
                                try {
                                    pdfiumCore.close();
                                }
                                catch (Exception exception) {}
                            }
                            n = n2;
                        }
                        catch (Exception exception) {
                            n = -1;
                        }
                        return Boxing.boxInt((int)n);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Integer> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static /* synthetic */ Object getPageCount$default(PDFThumbnailGenerator pDFThumbnailGenerator, Context context, Object object, String string, Continuation continuation, int n, Object object2) {
        if ((n & 4) != 0) {
            string = null;
        }
        return pDFThumbnailGenerator.getPageCount(context, object, string, (Continuation<? super Integer>)continuation);
    }

    public final void clearCache() {
        thumbnailCache.evictAll();
    }

    public final int getCacheSize() {
        return thumbnailCache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object generateThumbnailInternal(Context context, DocumentSource documentSource, int pageIndex, ThumbnailConfig config, String password, Continuation<? super Bitmap> $completion) {
        Bitmap bitmap;
        PdfiumCore pdfiumCore = new PdfiumCore();
        try {
            documentSource.createDocument(context, pdfiumCore, password);
            bitmap = this.generatePageThumbnail(pdfiumCore, pageIndex, config);
        }
        finally {
            try {
                pdfiumCore.close();
            }
            catch (Exception exception) {}
        }
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    private final Bitmap generatePageThumbnail(PdfiumCore pdfiumCore, int pageIndex, ThumbnailConfig config) {
        Bitmap bitmap;
        try {
            void height$iv;
            void width$iv;
            int pageCount = pdfiumCore.getPageCount();
            if (pageIndex < 0 || pageIndex >= pageCount) {
                return null;
            }
            pdfiumCore.openPage(pageIndex);
            Size pageSize = pdfiumCore.getPageSize(pageIndex);
            Triple<Integer, Integer, RectF> triple = this.calculateRenderDimensions(pageSize, config);
            int renderWidth = ((Number)triple.component1()).intValue();
            int renderHeight = ((Number)triple.component2()).intValue();
            RectF renderBounds = (RectF)triple.component3();
            int n = config.getWidth();
            int n2 = config.getHeight();
            Bitmap.Config config$iv = config.getQuality();
            boolean $i$f$createBitmap = false;
            Bitmap bitmap2 = Bitmap.createBitmap((int)width$iv, (int)height$iv, (Bitmap.Config)config$iv);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(width, height, config)");
            Bitmap thumbnail = bitmap2;
            if (config.getAspectRatio() == AspectRatio.PRESERVE) {
                Canvas canvas = new Canvas(thumbnail);
                canvas.drawColor(config.getBackgroundColor());
            }
            Bitmap.Config config$iv2 = config.getQuality();
            boolean $i$f$createBitmap2 = false;
            Bitmap bitmap3 = Bitmap.createBitmap((int)renderWidth, (int)renderHeight, (Bitmap.Config)config$iv2);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"createBitmap(width, height, config)");
            Bitmap renderBitmap = bitmap3;
            try {
                pdfiumCore.renderPageBitmap(renderBitmap, pageIndex, 0, 0, renderWidth, renderHeight, config.getAnnotationRendering());
                if (renderWidth == config.getWidth() && renderHeight == config.getHeight()) {
                    renderBitmap.recycle();
                    return thumbnail;
                }
                Canvas canvas = new Canvas(thumbnail);
                Paint paint = new Paint(3);
                canvas.drawBitmap(renderBitmap, null, renderBounds, paint);
                renderBitmap.recycle();
            }
            catch (PageRenderingException pageRenderingException) {
                renderBitmap.recycle();
                thumbnail.recycle();
                return null;
            }
            try {
                pdfiumCore.closePage(pageIndex);
            }
            catch (Exception exception) {
                // empty catch block
            }
            bitmap = thumbnail;
        }
        catch (Exception exception) {
            bitmap = null;
        }
        return bitmap;
    }

    private final Triple<Integer, Integer, RectF> calculateRenderDimensions(Size pageSize, ThumbnailConfig config) {
        float pageAspectRatio = (float)pageSize.getWidth() / (float)pageSize.getHeight();
        float thumbnailAspectRatio = (float)config.getWidth() / (float)config.getHeight();
        return switch (WhenMappings.$EnumSwitchMapping$0[config.getAspectRatio().ordinal()]) {
            case 1 -> new Triple((Object)config.getWidth(), (Object)config.getHeight(), (Object)new RectF(0.0f, 0.0f, (float)config.getWidth(), (float)config.getHeight()));
            case 2 -> {
                int scaledHeight = (int)((float)config.getWidth() / pageAspectRatio);
                int height = Math.min(scaledHeight, config.getHeight());
                float y = (float)(config.getHeight() - height) / 2.0f;
                yield new Triple((Object)config.getWidth(), (Object)height, (Object)new RectF(0.0f, y, (float)config.getWidth(), y + (float)height));
            }
            case 3 -> {
                int scaledWidth = (int)((float)config.getHeight() * pageAspectRatio);
                int width = Math.min(scaledWidth, config.getWidth());
                float x = (float)(config.getWidth() - width) / 2.0f;
                yield new Triple((Object)width, (Object)config.getHeight(), (Object)new RectF(x, 0.0f, x + (float)width, (float)config.getHeight()));
            }
            case 4 -> {
                if (pageAspectRatio > thumbnailAspectRatio) {
                    int scaledHeight = (int)((float)config.getWidth() / pageAspectRatio);
                    float y = (float)(config.getHeight() - scaledHeight) / 2.0f;
                    yield new Triple((Object)config.getWidth(), (Object)scaledHeight, (Object)new RectF(0.0f, y, (float)config.getWidth(), y + (float)scaledHeight));
                }
                int scaledWidth = (int)((float)config.getHeight() * pageAspectRatio);
                float x = (float)(config.getWidth() - scaledWidth) / 2.0f;
                yield new Triple((Object)scaledWidth, (Object)config.getHeight(), (Object)new RectF(x, 0.0f, x + (float)scaledWidth, (float)config.getHeight()));
            }
            case 5 -> {
                if (pageAspectRatio > thumbnailAspectRatio) {
                    int scaledWidth = (int)((float)config.getHeight() * pageAspectRatio);
                    yield new Triple((Object)scaledWidth, (Object)config.getHeight(), (Object)new RectF(0.0f, 0.0f, (float)config.getWidth(), (float)config.getHeight()));
                }
                int scaledHeight = (int)((float)config.getWidth() / pageAspectRatio);
                yield new Triple((Object)config.getWidth(), (Object)scaledHeight, (Object)new RectF(0.0f, 0.0f, (float)config.getWidth(), (float)config.getHeight()));
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String generateSourceIdentifier(Object source) {
        Object object;
        Object object2 = source;
        if (object2 instanceof File) {
            object = "file_" + ((File)source).getAbsolutePath() + "_" + ((File)source).lastModified() + "_" + ((File)source).length();
        } else if (object2 instanceof String) {
            object = "asset_" + source.hashCode();
        } else if (object2 instanceof byte[]) {
            object = "bytes_" + Arrays.hashCode((byte[])source);
        } else {
            String sourceString = source.toString();
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            String string = sourceString;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] hashBytes = digest.digest(byArray);
            Intrinsics.checkNotNull((Object)hashBytes);
            object = StringsKt.take((String)ArraysKt.joinToString$default((byte[])hashBytes, (CharSequence)"", null, null, (int)0, null, (Function1)generateSourceIdentifier.1.INSTANCE, (int)30, null), (int)16);
        }
        return object;
    }

    public static final /* synthetic */ String access$generateSourceIdentifier(PDFThumbnailGenerator $this, Object source) {
        return $this.generateSourceIdentifier(source);
    }

    public static final /* synthetic */ ThumbnailCache access$getThumbnailCache$p() {
        return thumbnailCache;
    }

    public static final /* synthetic */ Object access$generateThumbnailInternal(PDFThumbnailGenerator $this, Context context, DocumentSource documentSource, int pageIndex, ThumbnailConfig config, String password, Continuation $completion) {
        return $this.generateThumbnailInternal(context, documentSource, pageIndex, config, password, (Continuation<? super Bitmap>)$completion);
    }

    public static final /* synthetic */ Bitmap access$generatePageThumbnail(PDFThumbnailGenerator $this, PdfiumCore pdfiumCore, int pageIndex, ThumbnailConfig config) {
        return $this.generatePageThumbnail(pdfiumCore, pageIndex, config);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AspectRatio.values().length];
            try {
                nArray[AspectRatio.STRETCH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AspectRatio.FIT_WIDTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AspectRatio.FIT_HEIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AspectRatio.PRESERVE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AspectRatio.CROP_TO_FIT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

