/*
 * Decompiled with CFR 0.152.
 */
package com.harissk.pdfpreview;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.harissk.pdfium.exception.PageRenderingException;
import com.harissk.pdfium.listener.LogWriter;
import com.harissk.pdfpreview.PDFView;
import com.harissk.pdfpreview.PdfFile;
import com.harissk.pdfpreview.model.PagePart;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 &2\u00020\u0001:\u0002&'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JH\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eJ \u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0006\u0010$\u001a\u00020\u0010J\u0006\u0010%\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/harissk/pdfpreview/RenderingHandler;", "Landroid/os/Handler;", "looper", "Landroid/os/Looper;", "pdfView", "Lcom/harissk/pdfpreview/PDFView;", "(Landroid/os/Looper;Lcom/harissk/pdfpreview/PDFView;)V", "renderBounds", "Landroid/graphics/RectF;", "renderMatrix", "Landroid/graphics/Matrix;", "roundedRenderBounds", "Landroid/graphics/Rect;", "running", "", "addRenderingTask", "", "page", "", "width", "", "height", "bounds", "thumbnail", "cacheOrder", "bestQuality", "annotationRendering", "calculateBounds", "pageSliceBounds", "handleMessage", "message", "Landroid/os/Message;", "proceed", "Lcom/harissk/pdfpreview/model/PagePart;", "renderingTask", "Lcom/harissk/pdfpreview/RenderingHandler$RenderingTask;", "start", "stop", "Companion", "RenderingTask", "pdfpreview_release"})
@SourceDebugExtension(value={"SMAP\nRenderingHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderingHandler.kt\ncom/harissk/pdfpreview/RenderingHandler\n+ 2 Bitmap.kt\nandroidx/core/graphics/BitmapKt\n*L\n1#1,187:1\n95#2:188\n*S KotlinDebug\n*F\n+ 1 RenderingHandler.kt\ncom/harissk/pdfpreview/RenderingHandler\n*L\n118#1:188\n*E\n"})
public final class RenderingHandler
extends Handler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PDFView pdfView;
    @NotNull
    private final RectF renderBounds;
    @NotNull
    private final Rect roundedRenderBounds;
    @NotNull
    private final Matrix renderMatrix;
    private boolean running;
    public static final int MSG_RENDER_TASK = 1;
    @NotNull
    private static final String TAG = "RenderingHandler";

    public RenderingHandler(@NotNull Looper looper, @NotNull PDFView pdfView) {
        Intrinsics.checkNotNullParameter((Object)looper, (String)"looper");
        Intrinsics.checkNotNullParameter((Object)((Object)pdfView), (String)"pdfView");
        super(looper);
        this.pdfView = pdfView;
        this.renderBounds = new RectF();
        this.roundedRenderBounds = new Rect();
        this.renderMatrix = new Matrix();
    }

    public final void addRenderingTask(int page, float width, float height, @Nullable RectF bounds, boolean thumbnail, int cacheOrder, boolean bestQuality, boolean annotationRendering) {
        RenderingTask task = new RenderingTask(width, height, bounds, page, thumbnail, cacheOrder, bestQuality, annotationRendering);
        Message message = this.obtainMessage(1, task);
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"obtainMessage(...)");
        Message msg = message;
        this.sendMessage(msg);
    }

    public void handleMessage(@NotNull Message message) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Object object = message.obj;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.harissk.pdfpreview.RenderingHandler.RenderingTask");
            RenderingTask task = (RenderingTask)object;
            try {
                PagePart part = this.proceed(task);
                if (part != null) {
                    if (this.running && !this.pdfView.isRecycled$pdfpreview_release()) {
                        this.pdfView.post(() -> RenderingHandler.handleMessage$lambda$0(this, part));
                    } else {
                        Bitmap bitmap = part.getRenderedBitmap();
                        if (bitmap != null) {
                            bitmap.recycle();
                        }
                    }
                }
            }
            catch (PageRenderingException ex) {
                if (this.pdfView.isRecycled$pdfpreview_release()) break block6;
                this.pdfView.post(() -> RenderingHandler.handleMessage$lambda$1(this, ex));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PagePart proceed(RenderingTask renderingTask) throws PageRenderingException {
        PdfFile pdfFile2;
        if (this.pdfView.isRecycled$pdfpreview_release() || this.pdfView.isRecycling$pdfpreview_release()) {
            return null;
        }
        if (!this.running) {
            return null;
        }
        PdfFile pdfFile3 = pdfFile2 = this.pdfView.getPdfFile();
        synchronized (pdfFile3) {
            Bitmap render;
            int roundedHeight;
            int roundedWidth;
            block22: {
                Bitmap config$iv;
                block21: {
                    float h;
                    float w;
                    block20: {
                        block19: {
                            boolean bl = false;
                            if (!this.pdfView.isRecycled$pdfpreview_release() && !this.pdfView.isRecycling$pdfpreview_release() && this.running) break block19;
                            PagePart pagePart = null;
                            return pagePart;
                        }
                        pdfFile2.openPage(renderingTask.getPage());
                        w = renderingTask.getWidth();
                        h = renderingTask.getHeight();
                        if (!Float.isNaN(w) && !Float.isNaN(h) && !(w <= 0.0f) && !(h <= 0.0f)) break block20;
                        LogWriter logWriter = this.pdfView.getLogWriter();
                        if (logWriter != null) {
                            logWriter.writeLog("Invalid dimensions or page error: width=" + w + ", height=" + h, TAG);
                        }
                        PagePart pagePart = null;
                        return pagePart;
                    }
                    roundedWidth = MathKt.roundToInt((float)w);
                    roundedHeight = MathKt.roundToInt((float)h);
                    if (!this.pdfView.isRecycled$pdfpreview_release() && !this.pdfView.isRecycling$pdfpreview_release() && this.running) break block21;
                    PagePart pagePart = null;
                    return pagePart;
                }
                try {
                    Bitmap.Config config = renderingTask.getBestQuality() ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
                    boolean $i$f$createBitmap = false;
                    Bitmap bitmap = Bitmap.createBitmap((int)roundedWidth, (int)roundedHeight, (Bitmap.Config)config$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(width, height, config)");
                    config$iv = bitmap;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LogWriter logWriter = this.pdfView.getLogWriter();
                    if (logWriter != null) {
                        logWriter.writeLog("Cannot create bitmap", TAG);
                    }
                    PagePart pagePart = null;
                    return pagePart;
                }
                render = config$iv;
                if (!this.pdfView.isRecycled$pdfpreview_release() && !this.pdfView.isRecycling$pdfpreview_release() && this.running) break block22;
                render.recycle();
                PagePart pagePart = null;
                return pagePart;
            }
            try {
                RectF rectF = renderingTask.getBounds();
                if (rectF == null) {
                    rectF = new RectF();
                }
                this.calculateBounds(roundedWidth, roundedHeight, rectF);
                pdfFile2.renderPageBitmap(render, renderingTask.getPage(), this.roundedRenderBounds, renderingTask.getAnnotationRendering());
            }
            catch (Exception exception) {
                render.recycle();
                PagePart pagePart = null;
                return pagePart;
            }
            int n = renderingTask.getPage();
            RectF rectF = renderingTask.getBounds();
            if (rectF == null) {
                rectF = new RectF();
            }
            PagePart pagePart = new PagePart(n, render, rectF, renderingTask.getThumbnail(), renderingTask.getCacheOrder());
            return pagePart;
        }
    }

    private final void calculateBounds(int width, int height, RectF pageSliceBounds) {
        this.renderMatrix.reset();
        this.renderMatrix.postTranslate(-pageSliceBounds.left * (float)width, -pageSliceBounds.top * (float)height);
        this.renderMatrix.postScale(1.0f / pageSliceBounds.width(), 1.0f / pageSliceBounds.height());
        this.renderBounds.set(0.0f, 0.0f, (float)width, (float)height);
        this.renderMatrix.mapRect(this.renderBounds);
        this.renderBounds.round(this.roundedRenderBounds);
    }

    public final void stop() {
        this.running = false;
    }

    public final void start() {
        this.running = true;
    }

    private static final void handleMessage$lambda$0(RenderingHandler this$0, PagePart $part) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.pdfView.onBitmapRendered$pdfpreview_release($part);
    }

    private static final void handleMessage$lambda$1(RenderingHandler this$0, PageRenderingException $ex) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$ex), (String)"$ex");
        this$0.pdfView.onPageError$pdfpreview_release($ex);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/harissk/pdfpreview/RenderingHandler$Companion;", "", "()V", "MSG_RENDER_TASK", "", "TAG", "", "pdfpreview_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b)\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eJ\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010*\u001a\u00020\bH\u00c6\u0003J\t\u0010+\u001a\u00020\nH\u00c6\u0003J\t\u0010,\u001a\u00020\bH\u00c6\u0003J\t\u0010-\u001a\u00020\nH\u00c6\u0003J\t\u0010.\u001a\u00020\nH\u00c6\u0003J[\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\nH\u00c6\u0001J\u0013\u00100\u001a\u00020\n2\b\u00101\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00102\u001a\u00020\bH\u00d6\u0001J\t\u00103\u001a\u000204H\u00d6\u0001R\u001a\u0010\r\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u000b\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001a\"\u0004\b\"\u0010\u001cR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0010\"\u0004\b$\u0010\u0012R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001e\"\u0004\b&\u0010 \u00a8\u00065"}, d2={"Lcom/harissk/pdfpreview/RenderingHandler$RenderingTask;", "", "width", "", "height", "bounds", "Landroid/graphics/RectF;", "page", "", "thumbnail", "", "cacheOrder", "bestQuality", "annotationRendering", "(FFLandroid/graphics/RectF;IZIZZ)V", "getAnnotationRendering", "()Z", "setAnnotationRendering", "(Z)V", "getBestQuality", "setBestQuality", "getBounds", "()Landroid/graphics/RectF;", "setBounds", "(Landroid/graphics/RectF;)V", "getCacheOrder", "()I", "setCacheOrder", "(I)V", "getHeight", "()F", "setHeight", "(F)V", "getPage", "setPage", "getThumbnail", "setThumbnail", "getWidth", "setWidth", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "toString", "", "pdfpreview_release"})
    private static final class RenderingTask {
        private float width;
        private float height;
        @Nullable
        private RectF bounds;
        private int page;
        private boolean thumbnail;
        private int cacheOrder;
        private boolean bestQuality;
        private boolean annotationRendering;

        public RenderingTask(float width, float height, @Nullable RectF bounds, int page, boolean thumbnail, int cacheOrder, boolean bestQuality, boolean annotationRendering) {
            this.width = width;
            this.height = height;
            this.bounds = bounds;
            this.page = page;
            this.thumbnail = thumbnail;
            this.cacheOrder = cacheOrder;
            this.bestQuality = bestQuality;
            this.annotationRendering = annotationRendering;
        }

        public final float getWidth() {
            return this.width;
        }

        public final void setWidth(float f) {
            this.width = f;
        }

        public final float getHeight() {
            return this.height;
        }

        public final void setHeight(float f) {
            this.height = f;
        }

        @Nullable
        public final RectF getBounds() {
            return this.bounds;
        }

        public final void setBounds(@Nullable RectF rectF) {
            this.bounds = rectF;
        }

        public final int getPage() {
            return this.page;
        }

        public final void setPage(int n) {
            this.page = n;
        }

        public final boolean getThumbnail() {
            return this.thumbnail;
        }

        public final void setThumbnail(boolean bl) {
            this.thumbnail = bl;
        }

        public final int getCacheOrder() {
            return this.cacheOrder;
        }

        public final void setCacheOrder(int n) {
            this.cacheOrder = n;
        }

        public final boolean getBestQuality() {
            return this.bestQuality;
        }

        public final void setBestQuality(boolean bl) {
            this.bestQuality = bl;
        }

        public final boolean getAnnotationRendering() {
            return this.annotationRendering;
        }

        public final void setAnnotationRendering(boolean bl) {
            this.annotationRendering = bl;
        }

        public final float component1() {
            return this.width;
        }

        public final float component2() {
            return this.height;
        }

        @Nullable
        public final RectF component3() {
            return this.bounds;
        }

        public final int component4() {
            return this.page;
        }

        public final boolean component5() {
            return this.thumbnail;
        }

        public final int component6() {
            return this.cacheOrder;
        }

        public final boolean component7() {
            return this.bestQuality;
        }

        public final boolean component8() {
            return this.annotationRendering;
        }

        @NotNull
        public final RenderingTask copy(float width, float height, @Nullable RectF bounds, int page, boolean thumbnail, int cacheOrder, boolean bestQuality, boolean annotationRendering) {
            return new RenderingTask(width, height, bounds, page, thumbnail, cacheOrder, bestQuality, annotationRendering);
        }

        public static /* synthetic */ RenderingTask copy$default(RenderingTask renderingTask, float f, float f2, RectF rectF, int n, boolean bl, int n2, boolean bl2, boolean bl3, int n3, Object object) {
            if ((n3 & 1) != 0) {
                f = renderingTask.width;
            }
            if ((n3 & 2) != 0) {
                f2 = renderingTask.height;
            }
            if ((n3 & 4) != 0) {
                rectF = renderingTask.bounds;
            }
            if ((n3 & 8) != 0) {
                n = renderingTask.page;
            }
            if ((n3 & 0x10) != 0) {
                bl = renderingTask.thumbnail;
            }
            if ((n3 & 0x20) != 0) {
                n2 = renderingTask.cacheOrder;
            }
            if ((n3 & 0x40) != 0) {
                bl2 = renderingTask.bestQuality;
            }
            if ((n3 & 0x80) != 0) {
                bl3 = renderingTask.annotationRendering;
            }
            return renderingTask.copy(f, f2, rectF, n, bl, n2, bl2, bl3);
        }

        @NotNull
        public String toString() {
            return "RenderingTask(width=" + this.width + ", height=" + this.height + ", bounds=" + this.bounds + ", page=" + this.page + ", thumbnail=" + this.thumbnail + ", cacheOrder=" + this.cacheOrder + ", bestQuality=" + this.bestQuality + ", annotationRendering=" + this.annotationRendering + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.width);
            result = result * 31 + Float.hashCode(this.height);
            result = result * 31 + (this.bounds == null ? 0 : this.bounds.hashCode());
            result = result * 31 + Integer.hashCode(this.page);
            result = result * 31 + Boolean.hashCode(this.thumbnail);
            result = result * 31 + Integer.hashCode(this.cacheOrder);
            result = result * 31 + Boolean.hashCode(this.bestQuality);
            result = result * 31 + Boolean.hashCode(this.annotationRendering);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RenderingTask)) {
                return false;
            }
            RenderingTask renderingTask = (RenderingTask)other;
            if (Float.compare(this.width, renderingTask.width) != 0) {
                return false;
            }
            if (Float.compare(this.height, renderingTask.height) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.bounds, (Object)renderingTask.bounds)) {
                return false;
            }
            if (this.page != renderingTask.page) {
                return false;
            }
            if (this.thumbnail != renderingTask.thumbnail) {
                return false;
            }
            if (this.cacheOrder != renderingTask.cacheOrder) {
                return false;
            }
            if (this.bestQuality != renderingTask.bestQuality) {
                return false;
            }
            return this.annotationRendering == renderingTask.annotationRendering;
        }
    }
}

