/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.springboot3.ratelimiter.monitoring.health;

import io.github.resilience4j.common.ratelimiter.configuration.CommonRateLimiterConfigurationProperties;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.ratelimiter.internal.AtomicRateLimiter;
import io.github.resilience4j.spring6.ratelimiter.configure.RateLimiterConfigurationProperties;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.actuate.health.StatusAggregator;

public class RateLimitersHealthIndicator
implements HealthIndicator {
    private final RateLimiterRegistry rateLimiterRegistry;
    private final RateLimiterConfigurationProperties rateLimiterProperties;
    private final StatusAggregator statusAggregator;

    public RateLimitersHealthIndicator(RateLimiterRegistry rateLimiterRegistry, RateLimiterConfigurationProperties rateLimiterProperties, StatusAggregator statusAggregator) {
        this.rateLimiterRegistry = rateLimiterRegistry;
        this.rateLimiterProperties = rateLimiterProperties;
        this.statusAggregator = statusAggregator;
    }

    private static Health rateLimiterHealth(Status status, int availablePermissions, int numberOfWaitingThreads) {
        return Health.status((Status)status).withDetail("availablePermissions", (Object)availablePermissions).withDetail("numberOfWaitingThreads", (Object)numberOfWaitingThreads).build();
    }

    public Health health() {
        Map<String, Health> healths = this.rateLimiterRegistry.getAllRateLimiters().stream().filter(this::isRegisterHealthIndicator).collect(Collectors.toMap(RateLimiter::getName, this::mapRateLimiterHealth));
        Status status = this.statusAggregator.getAggregateStatus(healths.values().stream().map(Health::getStatus).collect(Collectors.toSet()));
        return Health.status((Status)status).withDetails(healths).build();
    }

    private boolean isRegisterHealthIndicator(RateLimiter rateLimiter) {
        return this.rateLimiterProperties.findRateLimiterProperties(rateLimiter.getName()).map(CommonRateLimiterConfigurationProperties.InstanceProperties::getRegisterHealthIndicator).orElse(false);
    }

    private boolean allowHealthIndicatorToFail(RateLimiter rateLimiter) {
        return this.rateLimiterProperties.findRateLimiterProperties(rateLimiter.getName()).map(CommonRateLimiterConfigurationProperties.InstanceProperties::getAllowHealthIndicatorToFail).orElse(false);
    }

    private Health mapRateLimiterHealth(RateLimiter rateLimiter) {
        AtomicRateLimiter atomicRateLimiter;
        AtomicRateLimiter.AtomicRateLimiterMetrics detailedMetrics;
        RateLimiter.Metrics metrics = rateLimiter.getMetrics();
        int availablePermissions = metrics.getAvailablePermissions();
        int numberOfWaitingThreads = metrics.getNumberOfWaitingThreads();
        long timeoutInNanos = rateLimiter.getRateLimiterConfig().getTimeoutDuration().toNanos();
        if (availablePermissions > 0 || numberOfWaitingThreads == 0) {
            return RateLimitersHealthIndicator.rateLimiterHealth(Status.UP, availablePermissions, numberOfWaitingThreads);
        }
        if (rateLimiter instanceof AtomicRateLimiter && (detailedMetrics = (atomicRateLimiter = (AtomicRateLimiter)rateLimiter).getDetailedMetrics()).getNanosToWait() > timeoutInNanos) {
            boolean allowHealthIndicatorToFail = this.allowHealthIndicatorToFail(rateLimiter);
            return RateLimitersHealthIndicator.rateLimiterHealth(allowHealthIndicatorToFail ? Status.DOWN : new Status("RATE_LIMITED"), availablePermissions, numberOfWaitingThreads);
        }
        return RateLimitersHealthIndicator.rateLimiterHealth(Status.UNKNOWN, availablePermissions, numberOfWaitingThreads);
    }
}

