/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.timelimiter.autoconfigure;

import io.github.resilience4j.common.CompositeCustomizer;
import io.github.resilience4j.common.timelimiter.configuration.TimeLimiterConfigCustomizer;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.ContextAwareScheduledThreadPoolExecutor;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.fallback.FallbackExecutor;
import io.github.resilience4j.fallback.autoconfigure.FallbackConfigurationOnMissingBean;
import io.github.resilience4j.spelresolver.SpelResolver;
import io.github.resilience4j.spelresolver.autoconfigure.SpelResolverConfigurationOnMissingBean;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import io.github.resilience4j.timelimiter.configure.ReactorTimeLimiterAspectExt;
import io.github.resilience4j.timelimiter.configure.RxJava2TimeLimiterAspectExt;
import io.github.resilience4j.timelimiter.configure.RxJava3TimeLimiterAspectExt;
import io.github.resilience4j.timelimiter.configure.TimeLimiterAspect;
import io.github.resilience4j.timelimiter.configure.TimeLimiterAspectExt;
import io.github.resilience4j.timelimiter.configure.TimeLimiterConfiguration;
import io.github.resilience4j.timelimiter.configure.TimeLimiterConfigurationProperties;
import io.github.resilience4j.timelimiter.event.TimeLimiterEvent;
import io.github.resilience4j.utils.AspectJOnClasspathCondition;
import io.github.resilience4j.utils.ReactorOnClasspathCondition;
import io.github.resilience4j.utils.RxJava2OnClasspathCondition;
import io.github.resilience4j.utils.RxJava3OnClasspathCondition;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@Configuration
@Import(value={FallbackConfigurationOnMissingBean.class, SpelResolverConfigurationOnMissingBean.class})
public abstract class AbstractTimeLimiterConfigurationOnMissingBean {
    protected final TimeLimiterConfiguration timeLimiterConfiguration = new TimeLimiterConfiguration();

    protected AbstractTimeLimiterConfigurationOnMissingBean() {
    }

    @Bean
    @ConditionalOnMissingBean(name={"compositeTimeLimiterCustomizer"})
    @Qualifier(value="compositeTimeLimiterCustomizer")
    public CompositeCustomizer<TimeLimiterConfigCustomizer> compositeTimeLimiterCustomizer(@Autowired(required=false) List<TimeLimiterConfigCustomizer> customizers) {
        return new CompositeCustomizer(customizers);
    }

    @Bean
    @ConditionalOnMissingBean
    public TimeLimiterRegistry timeLimiterRegistry(TimeLimiterConfigurationProperties timeLimiterProperties, EventConsumerRegistry<TimeLimiterEvent> timeLimiterEventsConsumerRegistry, RegistryEventConsumer<TimeLimiter> timeLimiterRegistryEventConsumer, @Qualifier(value="compositeTimeLimiterCustomizer") CompositeCustomizer<TimeLimiterConfigCustomizer> compositeTimeLimiterCustomizer) {
        return this.timeLimiterConfiguration.timeLimiterRegistry(timeLimiterProperties, timeLimiterEventsConsumerRegistry, timeLimiterRegistryEventConsumer, compositeTimeLimiterCustomizer);
    }

    @Bean
    @Primary
    public RegistryEventConsumer<TimeLimiter> timeLimiterRegistryEventConsumer(Optional<List<RegistryEventConsumer<TimeLimiter>>> optionalRegistryEventConsumers) {
        return this.timeLimiterConfiguration.timeLimiterRegistryEventConsumer(optionalRegistryEventConsumers);
    }

    @Bean
    @Conditional(value={AspectJOnClasspathCondition.class})
    @ConditionalOnMissingBean
    public TimeLimiterAspect timeLimiterAspect(TimeLimiterConfigurationProperties timeLimiterProperties, TimeLimiterRegistry timeLimiterRegistry, @Autowired(required=false) List<TimeLimiterAspectExt> timeLimiterAspectExtList, FallbackExecutor fallbackExecutor, SpelResolver spelResolver, @Autowired(required=false) ContextAwareScheduledThreadPoolExecutor contextAwareScheduledThreadPoolExecutor) {
        return this.timeLimiterConfiguration.timeLimiterAspect(timeLimiterProperties, timeLimiterRegistry, timeLimiterAspectExtList, fallbackExecutor, spelResolver, contextAwareScheduledThreadPoolExecutor);
    }

    @Bean
    @Conditional(value={RxJava2OnClasspathCondition.class, AspectJOnClasspathCondition.class})
    @ConditionalOnMissingBean
    public RxJava2TimeLimiterAspectExt rxJava2TimeLimiterAspectExt() {
        return this.timeLimiterConfiguration.rxJava2TimeLimiterAspectExt();
    }

    @Bean
    @Conditional(value={RxJava3OnClasspathCondition.class, AspectJOnClasspathCondition.class})
    @ConditionalOnMissingBean
    public RxJava3TimeLimiterAspectExt rxJava3TimeLimiterAspectExt() {
        return this.timeLimiterConfiguration.rxJava3TimeLimiterAspectExt();
    }

    @Bean
    @Conditional(value={ReactorOnClasspathCondition.class, AspectJOnClasspathCondition.class})
    @ConditionalOnMissingBean
    public ReactorTimeLimiterAspectExt reactorTimeLimiterAspectExt() {
        return this.timeLimiterConfiguration.reactorTimeLimiterAspectExt();
    }
}

