/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.monitoring.endpoint;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerEvent;
import io.github.resilience4j.common.circuitbreaker.monitoring.endpoint.CircuitBreakerEventDTOFactory;
import io.github.resilience4j.core.EventPublisher;
import io.github.resilience4j.reactor.adapter.ReactorAdapter;
import java.time.Duration;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.http.codec.ServerSentEvent;
import reactor.core.publisher.Flux;

@Endpoint(id="streamcircuitbreakerevents")
public class CircuitBreakerServerSideEvent {
    private final CircuitBreakerRegistry circuitBreakerRegistry;
    private final ObjectMapper jsonMapper = new ObjectMapper();

    public CircuitBreakerServerSideEvent(CircuitBreakerRegistry circuitBreakerRegistry) {
        this.circuitBreakerRegistry = circuitBreakerRegistry;
    }

    @ReadOperation(produces={"text/event-stream"})
    public Flux<ServerSentEvent<String>> getAllCircuitBreakerServerSideEvent() {
        Flux eventStreams = Flux.fromIterable((Iterable)this.circuitBreakerRegistry.getAllCircuitBreakers()).flatMap(circuitBreaker -> ReactorAdapter.toFlux((EventPublisher)circuitBreaker.getEventPublisher()));
        return Flux.merge((Publisher[])new Publisher[]{this.publishEvents((Flux<CircuitBreakerEvent>)eventStreams), this.getHeartbeatStream()});
    }

    @ReadOperation(produces={"text/event-stream"})
    public Flux<ServerSentEvent<String>> getEventsFilteredByCircuitBreakerName(@Selector String name) {
        CircuitBreaker circuitBreaker = this.getCircuitBreaker(name);
        Flux eventStream = ReactorAdapter.toFlux((EventPublisher)circuitBreaker.getEventPublisher());
        return Flux.merge((Publisher[])new Publisher[]{this.publishEvents((Flux<CircuitBreakerEvent>)eventStream), this.getHeartbeatStream()});
    }

    @ReadOperation(produces={"text/event-stream"})
    public Flux<ServerSentEvent<String>> getEventsFilteredByCircuitBreakerNameAndEventType(@Selector String name, @Selector String eventType) {
        CircuitBreaker circuitBreaker = this.getCircuitBreaker(name);
        Flux eventStream = ReactorAdapter.toFlux((EventPublisher)circuitBreaker.getEventPublisher()).filter(event -> event.getEventType() == CircuitBreakerEvent.Type.valueOf((String)eventType.toUpperCase()));
        return Flux.merge((Publisher[])new Publisher[]{this.publishEvents((Flux<CircuitBreakerEvent>)eventStream), this.getHeartbeatStream()});
    }

    private Flux<ServerSentEvent<String>> publishEvents(Flux<CircuitBreakerEvent> eventStreams) {
        Function<CircuitBreakerEvent, String> circuitBreakerEventDataFn = this.getCircuitBreakerEventStringFunction();
        return eventStreams.onBackpressureDrop().delayElements(Duration.ofMillis(100L)).map(cbEvent -> ServerSentEvent.builder().id(cbEvent.getCircuitBreakerName()).event(cbEvent.getEventType().name()).data((Object)((String)circuitBreakerEventDataFn.apply((CircuitBreakerEvent)cbEvent))).build());
    }

    private Function<CircuitBreakerEvent, String> getCircuitBreakerEventStringFunction() {
        return cbEvent -> {
            try {
                return this.jsonMapper.writeValueAsString((Object)CircuitBreakerEventDTOFactory.createCircuitBreakerEventDTO((CircuitBreakerEvent)cbEvent));
            }
            catch (JsonProcessingException jsonProcessingException) {
                return "";
            }
        };
    }

    private CircuitBreaker getCircuitBreaker(String circuitBreakerName) {
        return this.circuitBreakerRegistry.circuitBreaker(circuitBreakerName);
    }

    private Flux<ServerSentEvent<String>> getHeartbeatStream() {
        return Flux.interval((Duration)Duration.ofSeconds(1L)).map(i -> ServerSentEvent.builder().event("ping").build());
    }
}

