/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.rxjava3.micrometer.transformer;

import io.github.resilience4j.micrometer.Timer;
import io.github.resilience4j.rxjava3.AbstractSubscriber;
import io.reactivex.rxjava3.core.Flowable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

class FlowableTimer<T>
extends Flowable<T> {
    private final Timer timer;
    private final Publisher<T> upstream;

    FlowableTimer(Publisher<T> upstream, Timer timer) {
        this.timer = timer;
        this.upstream = upstream;
    }

    protected void subscribeActual(Subscriber<? super T> downstream) {
        this.upstream.subscribe((Subscriber)new TimerSubscriber(downstream, this.timer));
    }

    class TimerSubscriber
    extends AbstractSubscriber<T> {
        private final Timer.Context context;

        TimerSubscriber(Subscriber<? super T> downstreamObserver, Timer timer) {
            super(downstreamObserver);
            this.context = timer.createContext();
        }

        @Override
        protected void hookOnError(Throwable e) {
            this.context.onFailure(e);
        }

        @Override
        protected void hookOnComplete() {
            this.context.onSuccess();
        }

        @Override
        protected void hookOnCancel() {
            this.context.onSuccess();
        }
    }
}

