/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.rxjava3.circuitbreaker.operator;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.rxjava3.AbstractMaybeObserver;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;

class MaybeCircuitBreaker<T>
extends Maybe<T> {
    private final Maybe<T> upstream;
    private final CircuitBreaker circuitBreaker;

    MaybeCircuitBreaker(Maybe<T> upstream, CircuitBreaker circuitBreaker) {
        this.upstream = upstream;
        this.circuitBreaker = circuitBreaker;
    }

    protected void subscribeActual(MaybeObserver<? super T> downstream) {
        if (this.circuitBreaker.tryAcquirePermission()) {
            this.upstream.subscribe((MaybeObserver)new CircuitBreakerMaybeObserver(downstream));
        } else {
            downstream.onSubscribe((Disposable)EmptyDisposable.INSTANCE);
            downstream.onError((Throwable)CallNotPermittedException.createCallNotPermittedException((CircuitBreaker)this.circuitBreaker));
        }
    }

    class CircuitBreakerMaybeObserver
    extends AbstractMaybeObserver<T> {
        private final long start;

        CircuitBreakerMaybeObserver(MaybeObserver<? super T> downstreamObserver) {
            super(downstreamObserver);
            this.start = MaybeCircuitBreaker.this.circuitBreaker.getCurrentTimestamp();
        }

        @Override
        protected void hookOnComplete() {
            MaybeCircuitBreaker.this.circuitBreaker.onSuccess(MaybeCircuitBreaker.this.circuitBreaker.getCurrentTimestamp() - this.start, MaybeCircuitBreaker.this.circuitBreaker.getTimestampUnit());
        }

        @Override
        protected void hookOnError(Throwable e) {
            MaybeCircuitBreaker.this.circuitBreaker.onError(MaybeCircuitBreaker.this.circuitBreaker.getCurrentTimestamp() - this.start, MaybeCircuitBreaker.this.circuitBreaker.getTimestampUnit(), e);
        }

        @Override
        protected void hookOnSuccess(T value) {
            MaybeCircuitBreaker.this.circuitBreaker.onResult(MaybeCircuitBreaker.this.circuitBreaker.getCurrentTimestamp() - this.start, MaybeCircuitBreaker.this.circuitBreaker.getTimestampUnit(), value);
        }

        @Override
        protected void hookOnCancel() {
            MaybeCircuitBreaker.this.circuitBreaker.releasePermission();
        }
    }
}

