/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.rxjava3.micrometer.transformer;

import io.github.resilience4j.micrometer.Timer;
import io.github.resilience4j.rxjava3.micrometer.transformer.CompletableTimer;
import io.github.resilience4j.rxjava3.micrometer.transformer.FlowableTimer;
import io.github.resilience4j.rxjava3.micrometer.transformer.MaybeTimer;
import io.github.resilience4j.rxjava3.micrometer.transformer.ObservableTimer;
import io.github.resilience4j.rxjava3.micrometer.transformer.SingleTimer;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.CompletableTransformer;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.MaybeTransformer;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.ObservableTransformer;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.core.SingleTransformer;
import java.util.Objects;
import org.reactivestreams.Publisher;

public class TimerTransformer<T>
implements FlowableTransformer<T, T>,
SingleTransformer<T, T>,
MaybeTransformer<T, T>,
CompletableTransformer,
ObservableTransformer<T, T> {
    private final Timer timer;

    private TimerTransformer(Timer timer) {
        this.timer = Objects.requireNonNull(timer, "timer is null");
    }

    public static <T> TimerTransformer<T> of(Timer timer) {
        return new TimerTransformer<T>(timer);
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return new FlowableTimer<T>(upstream, this.timer);
    }

    public SingleSource<T> apply(Single<T> upstream) {
        return new SingleTimer<T>(upstream, this.timer);
    }

    public CompletableSource apply(Completable upstream) {
        return new CompletableTimer(upstream, this.timer);
    }

    public MaybeSource<T> apply(Maybe<T> upstream) {
        return new MaybeTimer<T>(upstream, this.timer);
    }

    public ObservableSource<T> apply(Observable<T> upstream) {
        return new ObservableTimer<T>(upstream, this.timer);
    }
}

