/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.rxjava3.ratelimiter.operator;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.rxjava3.ratelimiter.operator.CompletableRateLimiter;
import io.github.resilience4j.rxjava3.ratelimiter.operator.FlowableRateLimiter;
import io.github.resilience4j.rxjava3.ratelimiter.operator.MaybeRateLimiter;
import io.github.resilience4j.rxjava3.ratelimiter.operator.ObserverRateLimiter;
import io.github.resilience4j.rxjava3.ratelimiter.operator.SingleRateLimiter;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.CompletableTransformer;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.MaybeTransformer;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.ObservableTransformer;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.core.SingleTransformer;
import java.util.Objects;
import org.reactivestreams.Publisher;

public class RateLimiterOperator<T>
implements FlowableTransformer<T, T>,
SingleTransformer<T, T>,
MaybeTransformer<T, T>,
CompletableTransformer,
ObservableTransformer<T, T> {
    private final RateLimiter rateLimiter;

    private RateLimiterOperator(RateLimiter rateLimiter) {
        this.rateLimiter = Objects.requireNonNull(rateLimiter);
    }

    public static <T> RateLimiterOperator<T> of(RateLimiter rateLimiter) {
        return new RateLimiterOperator<T>(rateLimiter);
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return new FlowableRateLimiter<T>(upstream, this.rateLimiter);
    }

    public SingleSource<T> apply(Single<T> upstream) {
        return new SingleRateLimiter<T>(upstream, this.rateLimiter);
    }

    public CompletableSource apply(Completable upstream) {
        return new CompletableRateLimiter(upstream, this.rateLimiter);
    }

    public MaybeSource<T> apply(Maybe<T> upstream) {
        return new MaybeRateLimiter<T>(upstream, this.rateLimiter);
    }

    public ObservableSource<T> apply(Observable<T> upstream) {
        return new ObserverRateLimiter<T>(upstream, this.rateLimiter);
    }
}

