/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.rxjava3.retry.transformer;

import io.github.resilience4j.retry.Retry;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.CompletableTransformer;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.MaybeTransformer;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.ObservableTransformer;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.core.SingleTransformer;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;

public class RetryTransformer<T>
implements FlowableTransformer<T, T>,
ObservableTransformer<T, T>,
SingleTransformer<T, T>,
CompletableTransformer,
MaybeTransformer<T, T> {
    private final Retry retry;

    private RetryTransformer(Retry retry) {
        this.retry = retry;
    }

    public static <T> RetryTransformer<T> of(Retry retry) {
        return new RetryTransformer<T>(retry);
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        Context context = new Context(this.retry.asyncContext());
        return upstream.doOnNext(context::handleResult).retryWhen(errors -> errors.flatMap(context::handleFlowableErrors)).doOnComplete(context::onComplete);
    }

    public ObservableSource<T> apply(Observable<T> upstream) {
        Context context = new Context(this.retry.asyncContext());
        return upstream.doOnNext(context::handleResult).retryWhen(errors -> errors.flatMap(context::handleObservableErrors)).doOnComplete(context::onComplete);
    }

    public SingleSource<T> apply(Single<T> upstream) {
        Context context = new Context(this.retry.asyncContext());
        return upstream.doOnSuccess(context::handleResult).retryWhen(errors -> errors.flatMap(context::handleFlowableErrors)).doOnSuccess(t -> context.onComplete());
    }

    public CompletableSource apply(Completable upstream) {
        Context context = new Context(this.retry.asyncContext());
        return upstream.retryWhen(errors -> errors.flatMap(context::handleFlowableErrors)).doOnComplete(context::onComplete);
    }

    public MaybeSource<T> apply(Maybe<T> upstream) {
        Context context = new Context(this.retry.asyncContext());
        return upstream.doOnSuccess(context::handleResult).retryWhen(errors -> errors.flatMap(context::handleFlowableErrors)).doOnSuccess(t -> context.onComplete()).doOnComplete(context::onComplete);
    }

    private static class Context<T> {
        private final Retry.AsyncContext<T> retryContext;

        Context(Retry.AsyncContext<T> retryContext) {
            this.retryContext = retryContext;
        }

        void onComplete() {
            this.retryContext.onComplete();
        }

        void handleResult(T result) {
            long waitDurationMillis = this.retryContext.onResult(result);
            if (waitDurationMillis != -1L) {
                throw new RetryDueToResultException(waitDurationMillis);
            }
        }

        Publisher<Long> handleFlowableErrors(Throwable throwable) {
            if (throwable instanceof RetryDueToResultException) {
                long waitDurationMillis = ((RetryDueToResultException)throwable).waitDurationMillis;
                return Flowable.timer((long)waitDurationMillis, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            long waitDurationMillis = this.retryContext.onError(throwable);
            if (waitDurationMillis == -1L) {
                return Flowable.error((Throwable)throwable);
            }
            return Flowable.timer((long)waitDurationMillis, (TimeUnit)TimeUnit.MILLISECONDS);
        }

        ObservableSource<Long> handleObservableErrors(Throwable throwable) {
            if (throwable instanceof RetryDueToResultException) {
                long waitDurationMillis = ((RetryDueToResultException)throwable).waitDurationMillis;
                return Observable.timer((long)waitDurationMillis, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            long waitDurationMillis = this.retryContext.onError(throwable);
            if (waitDurationMillis == -1L) {
                return Observable.error((Throwable)throwable);
            }
            return Observable.timer((long)waitDurationMillis, (TimeUnit)TimeUnit.MILLISECONDS);
        }

        private static class RetryDueToResultException
        extends RuntimeException {
            private final long waitDurationMillis;

            RetryDueToResultException(long waitDurationMillis) {
                super("retry due to retryOnResult predicate");
                this.waitDurationMillis = waitDurationMillis;
            }
        }
    }
}

