/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.rxjava3.bulkhead.operator;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.github.resilience4j.rxjava3.AbstractObserver;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;

class ObserverBulkhead<T>
extends Observable<T> {
    private final Observable<T> upstream;
    private final Bulkhead bulkhead;

    ObserverBulkhead(Observable<T> upstream, Bulkhead bulkhead) {
        this.upstream = upstream;
        this.bulkhead = bulkhead;
    }

    protected void subscribeActual(Observer<? super T> downstream) {
        if (this.bulkhead.tryAcquirePermission()) {
            this.upstream.subscribe((Observer)new BulkheadObserver(downstream));
        } else {
            downstream.onSubscribe((Disposable)EmptyDisposable.INSTANCE);
            downstream.onError((Throwable)BulkheadFullException.createBulkheadFullException((Bulkhead)this.bulkhead));
        }
    }

    class BulkheadObserver
    extends AbstractObserver<T> {
        BulkheadObserver(Observer<? super T> downstreamObserver) {
            super(downstreamObserver);
        }

        @Override
        protected void hookOnError(Throwable e) {
            ObserverBulkhead.this.bulkhead.onComplete();
        }

        @Override
        protected void hookOnComplete() {
            ObserverBulkhead.this.bulkhead.onComplete();
        }

        @Override
        protected void hookOnCancel() {
            ObserverBulkhead.this.bulkhead.releasePermission();
        }
    }
}

