/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.rxjava3.circuitbreaker.operator;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.rxjava3.AbstractObserver;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import java.util.concurrent.TimeUnit;

class ObserverCircuitBreaker<T>
extends Observable<T> {
    private final Observable<T> upstream;
    private final CircuitBreaker circuitBreaker;

    ObserverCircuitBreaker(Observable<T> upstream, CircuitBreaker circuitBreaker) {
        this.upstream = upstream;
        this.circuitBreaker = circuitBreaker;
    }

    protected void subscribeActual(Observer<? super T> downstream) {
        if (this.circuitBreaker.tryAcquirePermission()) {
            this.upstream.subscribe((Observer)new CircuitBreakerObserver(downstream));
        } else {
            downstream.onSubscribe((Disposable)EmptyDisposable.INSTANCE);
            downstream.onError((Throwable)CallNotPermittedException.createCallNotPermittedException((CircuitBreaker)this.circuitBreaker));
        }
    }

    class CircuitBreakerObserver
    extends AbstractObserver<T> {
        private final long start;

        CircuitBreakerObserver(Observer<? super T> downstreamObserver) {
            super(downstreamObserver);
            this.start = System.nanoTime();
        }

        @Override
        protected void hookOnError(Throwable e) {
            ObserverCircuitBreaker.this.circuitBreaker.onError(System.nanoTime() - this.start, TimeUnit.NANOSECONDS, e);
        }

        @Override
        protected void hookOnComplete() {
            ObserverCircuitBreaker.this.circuitBreaker.onSuccess(System.nanoTime() - this.start, TimeUnit.NANOSECONDS);
        }

        @Override
        protected void hookOnCancel() {
            if (this.eventWasEmitted.get()) {
                ObserverCircuitBreaker.this.circuitBreaker.onSuccess(System.nanoTime() - this.start, TimeUnit.NANOSECONDS);
            } else {
                ObserverCircuitBreaker.this.circuitBreaker.releasePermission();
            }
        }
    }
}

