/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.transformer;

import io.github.resilience4j.AbstractCompletableObserver;
import io.github.resilience4j.micrometer.Timer;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;

class CompletableTimer
extends Completable {
    private final Completable upstream;
    private final Timer timer;

    CompletableTimer(Completable upstream, Timer timer) {
        this.upstream = upstream;
        this.timer = timer;
    }

    protected void subscribeActual(CompletableObserver downstream) {
        this.upstream.subscribe((CompletableObserver)new TimerCompletableObserver(downstream, this.timer));
    }

    class TimerCompletableObserver
    extends AbstractCompletableObserver {
        private final Timer.Context context;

        TimerCompletableObserver(CompletableObserver downstreamObserver, Timer timer) {
            super(downstreamObserver);
            this.context = timer.createContext();
        }

        @Override
        protected void hookOnComplete() {
            this.context.onSuccess();
        }

        @Override
        protected void hookOnError(Throwable e) {
            this.context.onFailure(e);
        }

        @Override
        protected void hookOnCancel() {
            this.context.onSuccess();
        }
    }
}

