/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.operator;

import io.github.resilience4j.AbstractSingleObserver;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;

class SingleCircuitBreaker<T>
extends Single<T> {
    private final CircuitBreaker circuitBreaker;
    private final Single<T> upstream;

    SingleCircuitBreaker(Single<T> upstream, CircuitBreaker circuitBreaker) {
        this.upstream = upstream;
        this.circuitBreaker = circuitBreaker;
    }

    protected void subscribeActual(SingleObserver<? super T> downstream) {
        if (this.circuitBreaker.tryAcquirePermission()) {
            this.upstream.subscribe((SingleObserver)new CircuitBreakerSingleObserver(downstream));
        } else {
            downstream.onSubscribe((Disposable)EmptyDisposable.INSTANCE);
            downstream.onError((Throwable)CallNotPermittedException.createCallNotPermittedException((CircuitBreaker)this.circuitBreaker));
        }
    }

    class CircuitBreakerSingleObserver
    extends AbstractSingleObserver<T> {
        private final long start;

        CircuitBreakerSingleObserver(SingleObserver<? super T> downstreamObserver) {
            super(downstreamObserver);
            this.start = SingleCircuitBreaker.this.circuitBreaker.getCurrentTimestamp();
        }

        @Override
        protected void hookOnError(Throwable e) {
            SingleCircuitBreaker.this.circuitBreaker.onError(SingleCircuitBreaker.this.circuitBreaker.getCurrentTimestamp() - this.start, SingleCircuitBreaker.this.circuitBreaker.getTimestampUnit(), e);
        }

        @Override
        protected void hookOnSuccess(T value) {
            SingleCircuitBreaker.this.circuitBreaker.onResult(SingleCircuitBreaker.this.circuitBreaker.getCurrentTimestamp() - this.start, SingleCircuitBreaker.this.circuitBreaker.getTimestampUnit(), value);
        }

        @Override
        protected void hookOnCancel() {
            SingleCircuitBreaker.this.circuitBreaker.releasePermission();
        }
    }
}

