/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.operator;

import io.github.resilience4j.AbstractSubscriber;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.reactivex.Flowable;
import io.reactivex.internal.subscriptions.EmptySubscription;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class FlowableCircuitBreaker<T>
extends Flowable<T> {
    private final CircuitBreaker circuitBreaker;
    private final Publisher<T> upstream;

    FlowableCircuitBreaker(Publisher<T> upstream, CircuitBreaker circuitBreaker) {
        this.circuitBreaker = Objects.requireNonNull(circuitBreaker);
        this.upstream = Objects.requireNonNull(upstream, "source is null");
    }

    protected void subscribeActual(Subscriber<? super T> downstream) {
        if (this.circuitBreaker.tryAcquirePermission()) {
            this.upstream.subscribe((Subscriber)new CircuitBreakerSubscriber(downstream));
        } else {
            downstream.onSubscribe((Subscription)EmptySubscription.INSTANCE);
            downstream.onError((Throwable)new CallNotPermittedException(this.circuitBreaker));
        }
    }

    class CircuitBreakerSubscriber
    extends AbstractSubscriber<T> {
        private final long start;

        CircuitBreakerSubscriber(Subscriber<? super T> downstreamSubscriber) {
            super(downstreamSubscriber);
            this.start = System.nanoTime();
        }

        @Override
        public void hookOnError(Throwable t) {
            FlowableCircuitBreaker.this.circuitBreaker.onError(System.nanoTime() - this.start, TimeUnit.NANOSECONDS, t);
        }

        @Override
        public void hookOnComplete() {
            FlowableCircuitBreaker.this.circuitBreaker.onSuccess(System.nanoTime() - this.start, TimeUnit.NANOSECONDS);
        }

        @Override
        public void hookOnCancel() {
            if (this.eventWasEmitted.get()) {
                FlowableCircuitBreaker.this.circuitBreaker.onSuccess(System.nanoTime() - this.start, TimeUnit.NANOSECONDS);
            } else {
                FlowableCircuitBreaker.this.circuitBreaker.releasePermission();
            }
        }
    }
}

