/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.operator;

import io.github.resilience4j.AbstractObserver;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;
import java.util.concurrent.TimeUnit;

class ObserverRateLimiter<T>
extends Observable<T> {
    private final Observable<T> upstream;
    private final RateLimiter rateLimiter;

    ObserverRateLimiter(Observable<T> upstream, RateLimiter rateLimiter) {
        this.upstream = upstream;
        this.rateLimiter = rateLimiter;
    }

    protected void subscribeActual(Observer<? super T> downstream) {
        long waitDuration = this.rateLimiter.reservePermission();
        if (waitDuration >= 0L) {
            if (waitDuration > 0L) {
                Completable.timer((long)waitDuration, (TimeUnit)TimeUnit.NANOSECONDS).subscribe(() -> this.upstream.subscribe((Observer)new RateLimiterObserver(downstream)));
            } else {
                this.upstream.subscribe((Observer)new RateLimiterObserver(downstream));
            }
        } else {
            downstream.onSubscribe((Disposable)EmptyDisposable.INSTANCE);
            downstream.onError((Throwable)new RequestNotPermitted(this.rateLimiter));
        }
    }

    class RateLimiterObserver
    extends AbstractObserver<T> {
        RateLimiterObserver(Observer<? super T> downstreamObserver) {
            super(downstreamObserver);
        }

        @Override
        protected void hookOnError(Throwable e) {
        }

        @Override
        protected void hookOnComplete() {
        }

        @Override
        protected void hookOnCancel() {
        }
    }
}

