/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.operator;

import io.github.resilience4j.AbstractCompletableObserver;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;
import java.time.Duration;

class CompletableRateLimiter
extends Completable {
    private final Completable upstream;
    private final RateLimiter rateLimiter;

    CompletableRateLimiter(Completable upstream, RateLimiter rateLimiter) {
        this.upstream = upstream;
        this.rateLimiter = rateLimiter;
    }

    protected void subscribeActual(CompletableObserver downstream) {
        if (this.rateLimiter.acquirePermission(Duration.ZERO)) {
            this.upstream.subscribe((CompletableObserver)new RateLimiterCompletableObserver(downstream));
        } else {
            downstream.onSubscribe((Disposable)EmptyDisposable.INSTANCE);
            downstream.onError((Throwable)new RequestNotPermitted(this.rateLimiter));
        }
    }

    class RateLimiterCompletableObserver
    extends AbstractCompletableObserver {
        RateLimiterCompletableObserver(CompletableObserver downstreamObserver) {
            super(downstreamObserver);
        }

        @Override
        protected void hookOnComplete() {
        }

        @Override
        protected void hookOnError(Throwable e) {
        }

        @Override
        protected void hookOnCancel() {
        }
    }
}

