/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.operator;

import io.github.resilience4j.adapter.Permit;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

abstract class DisposableRateLimiter<T>
extends AtomicReference<Disposable>
implements Disposable {
    private final RateLimiter rateLimiter;
    private final AtomicReference<Permit> permitted = new AtomicReference<Permit>(Permit.PENDING);

    DisposableRateLimiter(RateLimiter rateLimiter) {
        this.rateLimiter = Objects.requireNonNull(rateLimiter);
    }

    public final void dispose() {
        DisposableHelper.dispose((AtomicReference)this);
    }

    public final boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)((Disposable)this.get()));
    }

    protected void onSubscribeInner(Disposable disposable) {
    }

    protected final void onSubscribeWithPermit(Disposable disposable) {
        if (DisposableHelper.setOnce((AtomicReference)this, (Disposable)disposable)) {
            if (this.acquireCallPermit()) {
                this.onSubscribeInner(this);
            } else {
                this.dispose();
                this.onSubscribeInner(this);
                this.permittedOnError(this.rateLimitExceededException());
            }
        }
    }

    protected void permittedOnError(Throwable e) {
    }

    protected final void onErrorInner(Throwable e) {
        if (this.isInvocationPermitted()) {
            this.permittedOnError(e);
        }
    }

    protected void permittedOnComplete() {
    }

    protected final void onCompleteInner() {
        if (this.isInvocationPermitted()) {
            this.permittedOnComplete();
        }
    }

    protected void permittedOnSuccess(T value) {
    }

    protected final void onSuccessInner(T value) {
        if (this.isInvocationPermitted()) {
            this.permittedOnSuccess(value);
        }
    }

    protected void permittedOnNext(T value) {
    }

    protected final void onNextInner(T value, boolean firstEvent) {
        if (this.isInvocationPermitted()) {
            if (firstEvent || this.rateLimiter.getPermission(this.rateLimiter.getRateLimiterConfig().getTimeoutDuration())) {
                this.permittedOnNext(value);
            } else {
                this.dispose();
                this.permittedOnError(this.rateLimitExceededException());
            }
        }
    }

    private boolean isInvocationPermitted() {
        return !this.isDisposed() && this.wasCallPermitted();
    }

    private boolean acquireCallPermit() {
        boolean callPermitted = false;
        if (this.permitted.compareAndSet(Permit.PENDING, Permit.ACQUIRED) && !(callPermitted = this.rateLimiter.getPermission(this.rateLimiter.getRateLimiterConfig().getTimeoutDuration()))) {
            this.permitted.set(Permit.REJECTED);
        }
        return callPermitted;
    }

    private Exception rateLimitExceededException() {
        return new RequestNotPermitted("Request not permitted for limiter: " + this.rateLimiter.getName());
    }

    private boolean wasCallPermitted() {
        return this.permitted.get() == Permit.ACQUIRED;
    }
}

