/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.transformer;

import io.github.resilience4j.retry.Retry;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.SingleTransformer;
import io.reactivex.internal.subscriptions.SubscriptionArbiter;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryTransformer<T>
implements FlowableTransformer<T, T>,
ObservableTransformer<T, T>,
SingleTransformer<T, T> {
    private static final Logger LOG = LoggerFactory.getLogger(RetryTransformer.class);
    private final Retry retry;

    private RetryTransformer(Retry retry) {
        this.retry = retry;
    }

    public static <T> RetryTransformer<T> of(Retry retry) {
        return new RetryTransformer<T>(retry);
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return Flowable.fromPublisher(downstream -> {
            SubscriptionArbiter sa = new SubscriptionArbiter();
            downstream.onSubscribe((Subscription)sa);
            RetrySubscriber repeatSubscriber = new RetrySubscriber(downstream, this.retry.getRetryConfig().getMaxAttempts(), sa, upstream, this.retry);
            upstream.subscribe(repeatSubscriber);
        });
    }

    public ObservableSource<T> apply(Observable<T> upstream) {
        return Observable.fromPublisher(downstream -> {
            Flowable flowable = upstream.toFlowable(BackpressureStrategy.BUFFER);
            SubscriptionArbiter sa = new SubscriptionArbiter();
            downstream.onSubscribe((Subscription)sa);
            RetrySubscriber retrySubscriber = new RetrySubscriber(downstream, this.retry.getRetryConfig().getMaxAttempts(), sa, flowable, this.retry);
            flowable.subscribe(retrySubscriber);
        });
    }

    public SingleSource<T> apply(Single<T> upstream) {
        return Single.fromPublisher(downstream -> {
            Flowable flowable = upstream.toFlowable();
            SubscriptionArbiter sa = new SubscriptionArbiter();
            downstream.onSubscribe((Subscription)sa);
            RetrySubscriber retrySubscriber = new RetrySubscriber(downstream, this.retry.getRetryConfig().getMaxAttempts(), sa, flowable, this.retry);
            flowable.subscribe(retrySubscriber);
        });
    }

    static final class RetrySubscriber<T>
    extends AtomicInteger
    implements Subscriber<T> {
        private final Subscriber<? super T> actual;
        private final SubscriptionArbiter sa;
        private final Publisher<? extends T> source;
        private final Retry.Context context;
        private long remaining;

        RetrySubscriber(Subscriber<? super T> actual, long count, SubscriptionArbiter sa, Publisher<? extends T> source, Retry retry) {
            this.actual = actual;
            this.sa = sa;
            this.source = source;
            this.context = retry.context();
            this.remaining = count;
        }

        public void onSubscribe(Subscription s) {
            if (LOG.isDebugEnabled()) {
                LOG.info("onSubscribe");
            }
            this.sa.setSubscription(s);
        }

        public void onNext(T t) {
            if (LOG.isDebugEnabled()) {
                LOG.info("onNext");
            }
            this.context.onSuccess();
            this.actual.onNext(t);
            this.sa.produced(1L);
        }

        public void onError(Throwable t) {
            long r;
            if (LOG.isDebugEnabled()) {
                LOG.info("onError");
            }
            if ((r = this.remaining) != Long.MAX_VALUE) {
                this.remaining = r - 1L;
            }
            if (r == 0L) {
                this.actual.onError(t);
            } else {
                try {
                    this.context.onError((Exception)t);
                    this.subscribeNext();
                }
                catch (Throwable t2) {
                    this.actual.onError(t2);
                }
            }
        }

        public void onComplete() {
            if (LOG.isDebugEnabled()) {
                LOG.info("onComplete");
            }
            this.actual.onComplete();
        }

        private void subscribeNext() {
            block2: {
                if (this.getAndIncrement() != 0) break block2;
                int missed = 1;
                do {
                    if (this.sa.isCancelled()) {
                        return;
                    }
                    this.source.subscribe((Subscriber)this);
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }
    }
}

