/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.operator;

import io.github.resilience4j.adapter.Permit;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class BulkheadSubscriber<T>
extends AtomicReference<Subscription>
implements Subscriber<T>,
Subscription {
    private final Bulkhead bulkhead;
    private final Subscriber<? super T> childSubscriber;
    private final AtomicReference<Permit> permitted = new AtomicReference<Permit>(Permit.PENDING);

    BulkheadSubscriber(Bulkhead bulkhead, Subscriber<? super T> childSubscriber) {
        this.bulkhead = Objects.requireNonNull(bulkhead);
        this.childSubscriber = Objects.requireNonNull(childSubscriber);
    }

    public void onSubscribe(Subscription subscription) {
        if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)subscription)) {
            if (this.acquireCallPermit()) {
                this.childSubscriber.onSubscribe((Subscription)this);
            } else {
                this.cancel();
                this.childSubscriber.onSubscribe((Subscription)this);
                this.childSubscriber.onError((Throwable)new BulkheadFullException(String.format("Bulkhead '%s' is full", this.bulkhead.getName())));
            }
        }
    }

    public void onNext(T event) {
        if (this.isInvocationPermitted()) {
            this.childSubscriber.onNext(event);
        }
    }

    public void onError(Throwable e) {
        if (this.isInvocationPermitted()) {
            this.bulkhead.onComplete();
            this.childSubscriber.onError(e);
        }
    }

    public void onComplete() {
        if (this.isInvocationPermitted()) {
            this.releaseBulkhead();
            this.childSubscriber.onComplete();
        }
    }

    public void request(long n) {
        ((Subscription)this.get()).request(n);
    }

    public void cancel() {
        if (SubscriptionHelper.cancel((AtomicReference)this)) {
            this.releaseBulkhead();
        }
    }

    private boolean acquireCallPermit() {
        boolean callPermitted = false;
        if (this.permitted.compareAndSet(Permit.PENDING, Permit.ACQUIRED) && !(callPermitted = this.bulkhead.isCallPermitted())) {
            this.permitted.set(Permit.REJECTED);
        }
        return callPermitted;
    }

    private boolean isInvocationPermitted() {
        return !SubscriptionHelper.isCancelled((Subscription)((Subscription)this.get())) && this.wasCallPermitted();
    }

    private boolean wasCallPermitted() {
        return this.permitted.get() == Permit.ACQUIRED;
    }

    private void releaseBulkhead() {
        if (this.wasCallPermitted()) {
            this.bulkhead.onComplete();
        }
    }
}

